/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;

public class Network {
    private static final int MIN_NETWORK_BANDWIDTH_KBPS = 4000;

    public static int nextFreePort() {
        return Network.nextFreePort(4001, 65535);
    }

    public static int nextFreePort(int from, int to) {
        int port = ThreadLocalRandom.current().nextInt(from, to);
        while (!Network.isLocalPortFree(port)) {
            port = ThreadLocalRandom.current().nextInt(from, to);
        }
        return port;
    }

    public static boolean isLocalPortFree(int port) {
        try {
            new ServerSocket(port).close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static boolean isIPv6(@NonNull String ma) {
        Preconditions.checkNotNull((Object)ma);
        return ma.startsWith("/ip6/");
    }

    public static boolean isConnected(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasCapability(12);
    }

    public static boolean isConnectedWifi(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasTransport(1);
    }

    public static boolean isConnectedMobile(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        return capabilities != null && capabilities.hasTransport(0);
    }

    public static boolean isConnectedFast(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        if (capabilities == null) {
            return false;
        }
        return capabilities.hasCapability(11);
    }

    public boolean isConnectedMinHighBandwidth(@NonNull Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        android.net.Network network = connectivityManager.getActiveNetwork();
        if (network == null) {
            return false;
        }
        NetworkCapabilities capabilities = connectivityManager.getNetworkCapabilities(network);
        if (capabilities == null) {
            return false;
        }
        int bandwidth = capabilities.getLinkDownstreamBandwidthKbps();
        return bandwidth >= 4000;
    }

    @NonNull
    public static List<InetAddress> getValidInetAddresses() throws Exception {
        ArrayList<InetAddress> result = new ArrayList<InetAddress>();
        ArrayList<NetworkInterface> interfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
        for (NetworkInterface networkInterface : interfaces) {
            if (!networkInterface.isUp()) continue;
            ArrayList<InetAddress> addrs = Collections.list(networkInterface.getInetAddresses());
            for (InetAddress address : addrs) {
                if (address.isLoopbackAddress()) continue;
                if (address instanceof Inet4Address) {
                    if (!Network.isValidPublicIP(address)) continue;
                    result.add(address);
                    continue;
                }
                if (!(address instanceof Inet6Address) || !Network.isValidPublicIP(address)) continue;
                result.add(address);
            }
        }
        return result;
    }

    @Nullable
    private static Pair<InetAddress, Boolean> getInetAddress(boolean useIPv4) throws Exception {
        List<InetAddress> addresses = Network.getValidInetAddresses();
        Pair result = null;
        for (InetAddress addr : addresses) {
            if (addr.isLoopbackAddress()) continue;
            if (useIPv4) {
                if (!(addr instanceof Inet4Address)) continue;
                if (Network.isValidPublicIP(addr)) {
                    return Pair.create((Object)addr, (Object)true);
                }
                return Pair.create((Object)addr, (Object)false);
            }
            if (!(addr instanceof Inet6Address)) continue;
            if (Network.isValidPublicIP(addr)) {
                if (Network.isIPv6GlobalAddress((Inet6Address)addr)) {
                    return Pair.create((Object)addr, (Object)true);
                }
                result = Pair.create((Object)addr, (Object)false);
                continue;
            }
            if (result != null) continue;
            result = Pair.create((Object)addr, (Object)false);
        }
        return result;
    }

    public static boolean hasGlobalIPv6Address() throws Exception {
        Pair<InetAddress, Boolean> result = Network.getInetAddress(false);
        if (result == null) {
            return false;
        }
        return (Boolean)result.second;
    }

    private static boolean isIPv6GlobalAddress(@NonNull Inet6Address address) {
        Preconditions.checkNotNull((Object)address);
        if (address.isLinkLocalAddress()) {
            return false;
        }
        String host = address.getHostAddress();
        return (host.startsWith("2") || host.startsWith("3")) && host.indexOf(":") == 4;
    }

    private static boolean isValidPublicIP(@NonNull InetAddress address) {
        Preconditions.checkNotNull((Object)address);
        return !address.isSiteLocalAddress() && !address.isAnyLocalAddress() && !address.isLinkLocalAddress() && !address.isLoopbackAddress() && !address.isMulticastAddress();
    }
}

