/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum UserType {
    VERIFIED(0),
    UNKNOWN(1),
    ARTIFICIAL(2);

    @NonNull
    private final Integer code;

    private UserType(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static UserType toUserType(@NonNull Integer type) {
        Preconditions.checkNotNull((Object)type);
        if (type.equals(VERIFIED.getCode())) {
            return VERIFIED;
        }
        if (type.equals(UNKNOWN.getCode())) {
            return UNKNOWN;
        }
        if (type.equals(ARTIFICIAL.getCode())) {
            return ARTIFICIAL;
        }
        throw new IllegalArgumentException("Could not recognize type");
    }

    @TypeConverter
    public static Integer toInteger(@NonNull UserType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        return type.getCode();
    }

    @NonNull
    public Integer getCode() {
        return this.code;
    }
}

