/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Converter;
import threads.core.api.Peer;
import threads.core.api.PeerDao;
import threads.ipfs.api.CID;

public final class PeerDao_Impl
implements PeerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPeer;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPeer;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPeer;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfResetPeersConnected;
    private final SharedSQLiteStatement __preparedStmtOfSetConnected;
    private final SharedSQLiteStatement __preparedStmtOfIncrement;
    private final SharedSQLiteStatement __preparedStmtOfDecrement;

    public PeerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPeer = new EntityInsertionAdapter<Peer>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Peer`(`pid`,`multiAddress`,`isRelay`,`isAutonat`,`isPubsub`,`rating`,`life`,`alias`,`image`,`connected`,`additionals`,`hash`,`timestamp`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getMultiAddress() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMultiAddress());
                }
                int _tmp = value.isRelay() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                int _tmp_1 = value.isAutonat() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_1);
                int _tmp_2 = value.isPubsub() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                stmt.bindLong(6, (long)value.getRating());
                stmt.bindLong(7, (long)value.getLife());
                if (value.getAlias() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAlias());
                }
                String _tmp_3 = Converter.toString(value.getImage());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                int _tmp_4 = value.isConnected() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_4);
                String _tmp_5 = Additionals.toString(value.getAdditionals());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getHash());
                }
                stmt.bindLong(13, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfPeer = new EntityDeletionOrUpdateAdapter<Peer>(__db){

            public String createQuery() {
                return "DELETE FROM `Peer` WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
            }
        };
        this.__updateAdapterOfPeer = new EntityDeletionOrUpdateAdapter<Peer>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Peer` SET `pid` = ?,`multiAddress` = ?,`isRelay` = ?,`isAutonat` = ?,`isPubsub` = ?,`rating` = ?,`life` = ?,`alias` = ?,`image` = ?,`connected` = ?,`additionals` = ?,`hash` = ?,`timestamp` = ? WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getMultiAddress() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMultiAddress());
                }
                int _tmp = value.isRelay() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                int _tmp_1 = value.isAutonat() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_1);
                int _tmp_2 = value.isPubsub() ? 1 : 0;
                stmt.bindLong(5, (long)_tmp_2);
                stmt.bindLong(6, (long)value.getRating());
                stmt.bindLong(7, (long)value.getLife());
                if (value.getAlias() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getAlias());
                }
                String _tmp_3 = Converter.toString(value.getImage());
                if (_tmp_3 == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, _tmp_3);
                }
                int _tmp_4 = value.isConnected() ? 1 : 0;
                stmt.bindLong(10, (long)_tmp_4);
                String _tmp_5 = Additionals.toString(value.getAdditionals());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, value.getHash());
                }
                stmt.bindLong(13, value.getTimestamp());
                if (value.getPid() == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, value.getPid());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Peer";
                return "DELETE FROM Peer";
            }
        };
        this.__preparedStmtOfResetPeersConnected = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Peer SET connected = 0";
                return "UPDATE Peer SET connected = 0";
            }
        };
        this.__preparedStmtOfSetConnected = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Peer SET connected = ? WHERE pid = ?";
                return "UPDATE Peer SET connected = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfIncrement = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Peer SET life = life + 1  WHERE pid = ?";
                return "UPDATE Peer SET life = life + 1  WHERE pid = ?";
            }
        };
        this.__preparedStmtOfDecrement = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Peer SET life = life - 1  WHERE pid = ?";
                return "UPDATE Peer SET life = life - 1  WHERE pid = ?";
            }
        };
    }

    @Override
    public void insertPeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPeer.insert((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deletePeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPeer.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updatePeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPeer.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    @Override
    public void resetPeersConnected() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfResetPeersConnected.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfResetPeersConnected.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnected(String pid, boolean connected) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetConnected.acquire();
        int _argIndex = 1;
        int _tmp = connected ? 1 : 0;
        _stmt.bindLong(_argIndex, (long)_tmp);
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetConnected.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increment(String pid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfIncrement.acquire();
        int _argIndex = 1;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfIncrement.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrement(String pid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDecrement.acquire();
        int _argIndex = 1;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDecrement.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer getPeerByPid(String pid) {
        String _sql = "SELECT * FROM Peer WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Peer _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfIsPubsub = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPubsub");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfLife = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"life");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                _result = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _result.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _result.setAutonat(_tmpIsAutonat);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPubsub);
                boolean _tmpIsPubsub = _tmp_2 != 0;
                _result.setPubsub(_tmpIsPubsub);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _result.setRating(_tmpRating);
                int _tmpLife = _cursor.getInt(_cursorIndexOfLife);
                _result.setLife(_tmpLife);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                _result.setAlias(_tmpAlias);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _result.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_4 != 0;
                _result.setConnected(_tmpConnected);
                String _tmp_5 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_5);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Peer peer = _result;
            return peer;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Peer> getRelayPeers() {
        String _sql = "SELECT * FROM Peer WHERE isRelay = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE isRelay = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfIsPubsub = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPubsub");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfLife = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"life");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Peer> _result = new ArrayList<Peer>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                Peer _item = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _item.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _item.setAutonat(_tmpIsAutonat);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPubsub);
                boolean _tmpIsPubsub = _tmp_2 != 0;
                _item.setPubsub(_tmpIsPubsub);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _item.setRating(_tmpRating);
                int _tmpLife = _cursor.getInt(_cursorIndexOfLife);
                _item.setLife(_tmpLife);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                _item.setAlias(_tmpAlias);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_4 != 0;
                _item.setConnected(_tmpConnected);
                String _tmp_5 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_5);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Peer> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Peer> getAutonatPeers() {
        String _sql = "SELECT * FROM Peer WHERE isAutonat = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE isAutonat = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfIsPubsub = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPubsub");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfLife = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"life");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Peer> _result = new ArrayList<Peer>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                Peer _item = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _item.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _item.setAutonat(_tmpIsAutonat);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPubsub);
                boolean _tmpIsPubsub = _tmp_2 != 0;
                _item.setPubsub(_tmpIsPubsub);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _item.setRating(_tmpRating);
                int _tmpLife = _cursor.getInt(_cursorIndexOfLife);
                _item.setLife(_tmpLife);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                _item.setAlias(_tmpAlias);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_4 != 0;
                _item.setConnected(_tmpConnected);
                String _tmp_5 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_5);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Peer> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Peer> getPubsubPeers() {
        String _sql = "SELECT * FROM Peer WHERE isPubsub = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE isPubsub = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfIsPubsub = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPubsub");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfLife = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"life");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Peer> _result = new ArrayList<Peer>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                Peer _item = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _item.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _item.setAutonat(_tmpIsAutonat);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPubsub);
                boolean _tmpIsPubsub = _tmp_2 != 0;
                _item.setPubsub(_tmpIsPubsub);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _item.setRating(_tmpRating);
                int _tmpLife = _cursor.getInt(_cursorIndexOfLife);
                _item.setLife(_tmpLife);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                _item.setAlias(_tmpAlias);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_4 != 0;
                _item.setConnected(_tmpConnected);
                String _tmp_5 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_5);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Peer> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Peer>> getLiveDataPeers() {
        String _sql = "SELECT * FROM Peer";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Peer"}, false, (Callable)new Callable<List<Peer>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Peer> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PeerDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
                    int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
                    int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
                    int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
                    int _cursorIndexOfIsPubsub = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPubsub");
                    int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
                    int _cursorIndexOfLife = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"life");
                    int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Peer> _result = new ArrayList<Peer>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                        String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                        Peer _item = new Peer(_tmpPid, _tmpMultiAddress);
                        int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                        boolean _tmpIsRelay = _tmp != 0;
                        _item.setRelay(_tmpIsRelay);
                        int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                        boolean _tmpIsAutonat = _tmp_1 != 0;
                        _item.setAutonat(_tmpIsAutonat);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPubsub);
                        boolean _tmpIsPubsub = _tmp_2 != 0;
                        _item.setPubsub(_tmpIsPubsub);
                        int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                        _item.setRating(_tmpRating);
                        int _tmpLife = _cursor.getInt(_cursorIndexOfLife);
                        _item.setLife(_tmpLife);
                        String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                        _item.setAlias(_tmpAlias);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_3);
                        _item.setImage(_tmpImage);
                        int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                        boolean _tmpConnected = _tmp_4 != 0;
                        _item.setConnected(_tmpConnected);
                        String _tmp_5 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_5);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Peer> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int references(CID cid) {
        String _sql = "SELECT COUNT(pid) FROM Peer WHERE image =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(pid) FROM Peer WHERE image =?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnected(String pid) {
        String _sql = "SELECT connected FROM Peer WHERE pid = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT connected FROM Peer WHERE pid = ? ", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _tmp;
            boolean _result = _cursor.moveToFirst() ? (_tmp = _cursor.getInt(0)) != 0 : false;
            boolean bl = _result;
            return bl;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Peer> getPeers() {
        String _sql = "SELECT * FROM Peer";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfIsPubsub = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isPubsub");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfLife = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"life");
            int _cursorIndexOfAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"alias");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfConnected = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"connected");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Peer> _result = new ArrayList<Peer>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                Peer _item = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _item.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _item.setAutonat(_tmpIsAutonat);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsPubsub);
                boolean _tmpIsPubsub = _tmp_2 != 0;
                _item.setPubsub(_tmpIsPubsub);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _item.setRating(_tmpRating);
                int _tmpLife = _cursor.getInt(_cursorIndexOfLife);
                _item.setLife(_tmpLife);
                String _tmpAlias = _cursor.getString(_cursorIndexOfAlias);
                _item.setAlias(_tmpAlias);
                String _tmp_3 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_3);
                _item.setImage(_tmpImage);
                int _tmp_4 = _cursor.getInt(_cursorIndexOfConnected);
                boolean _tmpConnected = _tmp_4 != 0;
                _item.setConnected(_tmpConnected);
                String _tmp_5 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_5);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Peer> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

