package threads.core.api;

import androidx.annotation.NonNull;

import com.google.gson.Gson;

import java.util.HashMap;

import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkNotNull;

public class PeerInfoEncoder {
    @NonNull
    public static String convert(@NonNull PeerInfo peer, @NonNull String aesKey) {
        checkNotNull(peer);
        checkNotNull(aesKey);

        Content content = new Content();
        Gson gson = new Gson();
        try {

            Addresses addresses = peer.getAddresses();
            checkNotNull(addresses);
            if (!addresses.isEmpty()) {
                String peers = Addresses.toString(addresses);
                checkNotNull(peers);
                content.put(Content.PEERS, Encryption.encrypt(peers, aesKey));
            }


            MultiAddresses multiAddresses = peer.getMultiAddresses();
            checkNotNull(multiAddresses);
            if (!multiAddresses.isEmpty()) {
                String mass = MultiAddresses.toString(multiAddresses);
                checkNotNull(mass);
                content.put(Content.MADS, Encryption.encrypt(mass, aesKey));
            }


            HashMap<String, String> additions = peer.getExternalAdditions();
            checkNotNull(additions);
            content.put(Content.ADDS, Encryption.encrypt(Additionals.toString(additions), aesKey));

            // NOT ENCRYPTED
            content.put(Content.DATE, String.valueOf(peer.getTimestamp()));

            return gson.toJson(content);


        } catch (Throwable e) {
            throw new RuntimeException(e);
        }


    }
}
