/*
 * Decompiled with CFR 0.152.
 */
package threads.core.mdl;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MediatorLiveData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import threads.core.Singleton;
import threads.core.api.IPeer;
import threads.core.api.Peer;
import threads.core.api.PeersDatabase;
import threads.core.api.ThreadsDatabase;
import threads.core.api.User;

public class PeersMediatorViewModel
extends AndroidViewModel {
    private final List<IPeer> storedPeers = new ArrayList<IPeer>();
    @NonNull
    private final MediatorLiveData<List<IPeer>> liveDataMerger = new MediatorLiveData();
    @NonNull
    private final ThreadsDatabase threadsDatabase;
    @NonNull
    private final PeersDatabase peersDatabase;

    public PeersMediatorViewModel(@NonNull Application application) {
        super(application);
        this.threadsDatabase = Singleton.getInstance(application.getApplicationContext()).getThreadsDatabase();
        this.peersDatabase = Singleton.getInstance(application.getApplicationContext()).getPeersDatabase();
        LiveData<List<User>> liveDataUsers = this.threadsDatabase.userDao().getLiveDataUsers();
        this.liveDataMerger.addSource(liveDataUsers, users -> {
            if (users != null) {
                this.storedPeers.clear();
                this.storedPeers.addAll((Collection<IPeer>)users);
            }
        });
        LiveData<List<Peer>> liveDataPeers = this.peersDatabase.peersDao().getLiveDataPeers();
        this.liveDataMerger.addSource(liveDataPeers, users -> {
            if (users != null) {
                ArrayList<IPeer> peers = new ArrayList<IPeer>(this.storedPeers);
                peers.addAll((Collection<IPeer>)users);
                this.liveDataMerger.setValue(peers);
            }
        });
    }

    @NonNull
    public LiveData<List<IPeer>> getPeers() {
        return this.liveDataMerger;
    }
}

