/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import threads.core.Network;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Peer;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.ipfs.api.PeerInfo;

public class GatewayService {
    public static final String TAG = GatewayService.class.getSimpleName();

    public static int evaluateAllPeers(@NonNull Context context) {
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Preconditions.checkNotNull((Object)ipfs);
        List peers = ipfs.swarmPeers();
        int size = peers.size();
        for (threads.ipfs.api.Peer peer : peers) {
            if (peer.getMultiAddress().endsWith("/p2p-circuit")) continue;
            GatewayService.storePeer(context, peer);
        }
        return size;
    }

    public static int evaluatePeers(@NonNull Context context, boolean pubsubs) {
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Preconditions.checkNotNull((Object)ipfs);
        List peers = ipfs.swarmPeers();
        int size = peers.size();
        for (threads.ipfs.api.Peer peer : peers) {
            if (peer.getMultiAddress().endsWith("/p2p-circuit")) continue;
            if (pubsubs) {
                if (!peer.isAutonat() && !peer.isRelay() && !peer.isMeshSub() && !peer.isFloodSub()) continue;
                GatewayService.storePeer(context, peer);
                continue;
            }
            if (!peer.isAutonat() && !peer.isRelay()) continue;
            GatewayService.storePeer(context, peer);
        }
        return size;
    }

    public static synchronized List<Peer> getRelayPeers(@NonNull Context context, @NonNull String tag, int numRelays, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numRelays >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Peer> result = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return result;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            peers.sort(threads.ipfs.api.Peer::compareTo);
            for (threads.ipfs.api.Peer peer : peers) {
                if (result.size() == numRelays) break;
                if (!peer.isRelay()) continue;
                if (ipfs.isConnected(peer.getPid())) {
                    if (!tag.isEmpty()) {
                        ipfs.protectPeer(peer.getPid(), tag);
                    }
                    result.add(GatewayService.storePeer(context, peer));
                    continue;
                }
                if (!ipfs.swarmConnect(peer, timeout)) continue;
                if (!tag.isEmpty()) {
                    ipfs.protectPeer(peer.getPid(), tag);
                }
                result.add(GatewayService.storePeer(context, peer));
            }
        }
        return result;
    }

    public static void fillPeerList(@NonNull Context context, @NonNull List<Peer> list, @NonNull String tag, int numPeers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(list);
        Preconditions.checkNotNull((Object)tag);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            peers.sort(threads.ipfs.api.Peer::compareTo);
            for (threads.ipfs.api.Peer peer : peers) {
                if (list.size() == numPeers) break;
                if (!ipfs.isConnected(peer.getPid())) continue;
                if (!tag.isEmpty()) {
                    ipfs.protectPeer(peer.getPid(), tag);
                }
                list.add(GatewayService.storePeer(context, peer));
            }
        }
    }

    private static Peer storePeer(@NonNull Context context, @NonNull threads.ipfs.api.Peer peer) {
        int rating = 0;
        try {
            double latency = peer.getLatency();
            if (latency < 1000.0) {
                rating = (int)(1000.0 - latency);
            }
        }
        catch (Throwable latency) {
            // empty catch block
        }
        boolean isConnected = false;
        try {
            int timeout = 5;
            IPFS ipfs = Singleton.getInstance(context).getIpfs();
            if (ipfs != null) {
                PeerInfo info = ipfs.id(peer, timeout);
                if (info != null) {
                    String protocol = info.getProtocolVersion();
                    String agent = info.getAgentVersion();
                    rating = protocol != null && protocol.equals("ipfs/0.1.0") ? (rating += 100) : (rating -= 100);
                    if (agent != null) {
                        if (agent.startsWith("go-ipfs/0.4.2")) {
                            rating += 100;
                        } else if (agent.startsWith("go-ipfs/0.5")) {
                            rating += 150;
                        }
                    }
                }
                isConnected = ipfs.isConnected(peer.getPid());
            }
        }
        catch (Throwable timeout) {
            // empty catch block
        }
        if (rating < 0) {
            rating = 0;
        }
        boolean isPubsub = peer.isFloodSub() || peer.isMeshSub();
        return GatewayService.storePeer(context, peer.getPid(), peer.getMultiAddress(), peer.isRelay(), peer.isAutonat(), isPubsub, isConnected, rating);
    }

    @NonNull
    private static Peer storePeer(@NonNull Context context, @NonNull PID pid, @NonNull String multiAddress, boolean isRelay, boolean isAutonat, boolean isPubsub, boolean isConnected, int rating) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        Peer peer = threads.getPeerByPID(pid);
        if (peer != null) {
            peer.setMultiAddress(multiAddress);
            peer.setRelay(isRelay);
            peer.setAutonat(isAutonat);
            peer.setPubsub(isPubsub);
            peer.setRating(rating);
            peer.setConnected(isConnected);
            threads.updatePeer(peer);
            Log.e((String)TAG, (String)("Update Peer  : " + peer.toString()));
        } else {
            peer = threads.createPeer(pid, multiAddress);
            peer.setRelay(isRelay);
            peer.setAutonat(isAutonat);
            peer.setPubsub(isPubsub);
            peer.setRating(rating);
            peer.setConnected(isConnected);
            threads.storePeer(peer);
            Log.e((String)TAG, (String)("Store Peer  : " + peer.toString()));
        }
        return peer;
    }

    public static void connectStoredAutonat(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getAutonatPeers();
            peers.sort(Peer::compareTo);
            for (Peer autonat : peers) {
                int life;
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Autonat : " + autonat.toString()));
                if (ipfs.isConnected(PID.create((String)autonat.getPid()))) {
                    counter.incrementAndGet();
                    int life2 = autonat.getLife();
                    if (life2 >= 5) continue;
                    threads.incrementLife(autonat);
                    continue;
                }
                String ma = autonat.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + autonat.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    life = autonat.getLife();
                    if (life >= 5) continue;
                    threads.incrementLife(autonat);
                    continue;
                }
                if (!Network.isConnectedFast(context)) continue;
                life = autonat.getLife();
                if (life < 0) {
                    threads.removePeer(ipfs, autonat);
                    continue;
                }
                threads.decrementLife(autonat);
            }
        }
    }

    public static void connectStoredPubsub(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getPubsubPeers();
            peers.sort(Peer::compareTo);
            for (Peer pubsub : peers) {
                int life;
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Pubsub : " + pubsub.toString()));
                if (ipfs.isConnected(PID.create((String)pubsub.getPid()))) {
                    counter.incrementAndGet();
                    int life2 = pubsub.getLife();
                    if (life2 >= 5) continue;
                    threads.incrementLife(pubsub);
                    continue;
                }
                String ma = pubsub.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + pubsub.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    life = pubsub.getLife();
                    if (life >= 5) continue;
                    threads.incrementLife(pubsub);
                    continue;
                }
                if (!Network.isConnectedFast(context)) continue;
                life = pubsub.getLife();
                if (life < 0) {
                    threads.removePeer(ipfs, pubsub);
                    continue;
                }
                threads.decrementLife(pubsub);
            }
        }
    }

    public static void connectStoredRelays(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getRelayPeers();
            peers.sort(Peer::compareTo);
            for (Peer relay : peers) {
                int life;
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Relay : " + relay.toString()));
                if (ipfs.isConnected(PID.create((String)relay.getPid()))) {
                    counter.incrementAndGet();
                    int life2 = relay.getLife();
                    if (life2 >= 5) continue;
                    threads.decrementLife(relay);
                    continue;
                }
                String ma = relay.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + relay.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    life = relay.getLife();
                    if (life >= 5) continue;
                    threads.incrementLife(relay);
                    continue;
                }
                if (!Network.isConnectedFast(context)) continue;
                life = relay.getLife();
                if (life < 0) {
                    threads.removePeer(ipfs, relay);
                    continue;
                }
                threads.incrementLife(relay);
            }
        }
    }

    public static void connectStoredPeers(@NonNull Context context, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        if (ipfs != null) {
            List<Peer> peers = threads.getPeers();
            peers.sort(Peer::compareTo);
            for (Peer peer : peers) {
                String ma;
                Log.e((String)TAG, (String)("Stored Peer : " + peer.toString()));
                if (ipfs.isConnected(PID.create((String)peer.getPid())) || ipfs.swarmConnect(ma = peer.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + peer.getPid(), timeout) || !Network.isConnectedFast(context)) continue;
                threads.removePeer(ipfs, peer);
            }
        }
    }
}

