/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.TypeConverters;
import androidx.room.Update;
import java.util.Date;
import java.util.List;
import threads.core.api.Converter;
import threads.core.api.Kind;
import threads.core.api.Status;
import threads.core.api.Thread;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@Dao
public interface ThreadDao {
    @Insert(onConflict=1)
    public long insertThread(Thread var1);

    @Insert(onConflict=1)
    public void insertThreads(Thread ... var1);

    @Query(value="SELECT * FROM Thread")
    public List<Thread> getThreads();

    @Query(value="SELECT * FROM Thread")
    public LiveData<List<Thread>> getLiveDataThreads();

    @Query(value="DELETE FROM Thread")
    public void clear();

    @Query(value="SELECT * FROM Thread WHERE date =:date")
    @TypeConverters(value={Converter.class})
    public List<Thread> getThreadsByDate(Date var1);

    @Query(value="SELECT * FROM Thread WHERE expireDate < :date")
    @TypeConverters(value={Converter.class})
    public List<Thread> getExpiredThreads(Date var1);

    @Query(value="SELECT * FROM Thread WHERE kind LIKE :kind AND status = :status")
    @TypeConverters(value={Kind.class, Status.class})
    public List<Thread> getThreadsByKindAndThreadStatus(Kind var1, Status var2);

    @Query(value="SELECT * FROM Thread WHERE pinned = :pinned")
    public List<Thread> getThreadsByPinned(boolean var1);

    @Query(value="SELECT mimeType FROM Thread WHERE idx = :idx")
    public String getMimeType(long var1);

    @Query(value="SELECT cid FROM Thread WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public CID getCid(long var1);

    @Query(value="UPDATE Thread SET status = :status  WHERE idx = :idx")
    @TypeConverters(value={Status.class})
    public void setStatus(long var1, Status var3);

    @Query(value="UPDATE Thread SET publish = :publish  WHERE idx = :idx")
    public void setPublish(long var1, boolean var3);

    @Query(value="UPDATE Thread SET date = :date  WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public void setThreadDate(long var1, Date var3);

    @Query(value="UPDATE Thread SET status = :status  WHERE idx IN (:idxs)")
    @TypeConverters(value={Status.class})
    public void setThreadsStatus(Status var1, long ... var2);

    @Query(value="UPDATE Thread SET publish = :publish  WHERE idx IN (:idxs)")
    public void setThreadsPublish(boolean var1, long ... var2);

    @Query(value="UPDATE Thread SET senderAlias = :alias  WHERE idx = :idx")
    public void setSenderAlias(long var1, String var3);

    @Query(value="UPDATE Thread SET pinned = :pinned  WHERE idx = :idx")
    public void setPinned(long var1, boolean var3);

    @Query(value="SELECT pinned FROM Thread WHERE idx = :idx")
    public boolean isPinned(long var1);

    @Query(value="UPDATE Thread SET senderAlias = :alias  WHERE senderPid = :pid")
    @TypeConverters(value={Converter.class})
    public void setSenderAlias(PID var1, String var2);

    @Query(value="UPDATE Thread SET status = :newStatus  WHERE status = :oldStatus")
    @TypeConverters(value={Status.class})
    public void setStatus(Status var1, Status var2);

    @Query(value="SELECT * FROM Thread WHERE status = :status")
    @TypeConverters(value={Status.class})
    public List<Thread> getThreadsByStatus(Status var1);

    @Query(value="SELECT * FROM Thread WHERE cid = :cid")
    @TypeConverters(value={Converter.class})
    public List<Thread> getThreadsByCid(CID var1);

    @Query(value="SELECT * FROM Thread WHERE cid = :cid AND thread = :thread")
    @TypeConverters(value={Converter.class})
    public List<Thread> getThreadsByCidAndThread(CID var1, long var2);

    @Delete
    public void removeThreads(Thread ... var1);

    @Update(onConflict=1)
    public void updateThreads(Thread ... var1);

    @Query(value="UPDATE Thread SET unreadNotes = 0 WHERE idx IN (:idxs)")
    public void resetUnreadNotes(long ... var1);

    @Query(value="UPDATE Thread SET publish = 0")
    public void resetThreadsPublish();

    @Query(value="UPDATE Thread SET unreadNotes = 0 WHERE thread IN (:threads)")
    public void resetThreadUnreadNotes(long ... var1);

    @Query(value="Select SUM(unreadNotes) FROM THREAD")
    public int getUnreadNotes();

    @Query(value="SELECT COUNT(idx) FROM Thread WHERE cid =:cid OR image =:cid")
    @TypeConverters(value={Converter.class})
    public int references(CID var1);

    @Query(value="SELECT * FROM Thread WHERE thread =:thread")
    public List<Thread> getThreadsByThread(long var1);

    @Query(value="SELECT * FROM Thread WHERE idx =:idx")
    public Thread getThreadByIdx(long var1);

    @Query(value="SELECT * FROM Thread WHERE idx IN(:idxs)")
    public List<Thread> getThreadByIdxs(long ... var1);

    @Query(value="SELECT * FROM Thread WHERE senderPid =:senderPid")
    @TypeConverters(value={Converter.class})
    public List<Thread> getThreadsBySenderPid(PID var1);

    @Query(value="SELECT * FROM Thread WHERE thread =:thread")
    public LiveData<List<Thread>> getLiveDataThreadsByThread(long var1);

    @Query(value="UPDATE Thread SET unreadNotes = unreadNotes + 1  WHERE idx IN(:idxs)")
    public void incrementUnreadNotesNumber(long ... var1);

    @Query(value="UPDATE Thread SET cid =:cid  WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public void setCid(long var1, CID var3);

    @Query(value="UPDATE Thread SET mimeType =:mimeType  WHERE idx = :idx")
    public void setMimeType(long var1, String var3);

    @Query(value="UPDATE Thread SET hash = :hash WHERE idx = :idx")
    public void setHash(long var1, String var3);

    @Query(value="UPDATE Thread SET image = :image WHERE idx = :idx")
    @TypeConverters(value={Converter.class})
    public void setImage(long var1, CID var3);

    @Query(value="SELECT status FROM Thread WHERE idx = :idx")
    @TypeConverters(value={Status.class})
    public Status getStatus(long var1);

    @Query(value="SELECT markedFlag FROM Thread WHERE idx = :idx")
    public boolean getMarkedFlag(long var1);

    @Query(value="UPDATE Thread SET markedFlag = :flag WHERE idx = :idx")
    public void setMarkedFlag(long var1, boolean var3);

    @Query(value="UPDATE Thread SET unreadNotes = :unreadNotes  WHERE idx = :idx")
    public void setUnreadNotesNumber(long var1, int var3);
}

