/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverters;
import java.util.Date;
import java.util.Objects;
import threads.core.THREADS;
import threads.core.api.AddressType;
import threads.core.api.Converter;
import threads.core.api.Entity;
import threads.core.api.Kind;
import threads.core.api.Members;
import threads.core.api.ThreadStatus;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class Thread
extends Entity {
    @ColumnInfo(name="thread")
    private final long thread;
    @NonNull
    @TypeConverters(value={Kind.class})
    @ColumnInfo(name="kind")
    private final Kind kind;
    @NonNull
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="senderPid")
    private final PID senderPid;
    @NonNull
    @ColumnInfo(name="senderKey")
    private final String senderKey;
    @NonNull
    @ColumnInfo(name="sesKey")
    private final String sesKey;
    @NonNull
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="date")
    private Date date;
    @Deprecated
    @ColumnInfo(name="readOnly")
    private boolean readOnly;
    @NonNull
    @ColumnInfo(name="senderAlias")
    private String senderAlias;
    @PrimaryKey(autoGenerate=true)
    private long idx;
    @Nullable
    @ColumnInfo(name="image")
    @TypeConverters(value={Converter.class})
    private CID image;
    @ColumnInfo(name="markedFlag")
    private boolean markedFlag;
    @ColumnInfo(name="unreadNotes")
    private int unreadNotes = 0;
    @Nullable
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="cid")
    private CID cid;
    @NonNull
    @TypeConverters(value={Converter.class})
    @ColumnInfo(name="expireDate")
    private Date expireDate;
    @NonNull
    @TypeConverters(value={ThreadStatus.class})
    @ColumnInfo(name="status")
    private ThreadStatus status;
    @NonNull
    @TypeConverters(value={Members.class})
    @ColumnInfo(name="members")
    private Members members = new Members();
    @NonNull
    @ColumnInfo(name="mimeType")
    private String mimeType;
    @ColumnInfo(name="pinned")
    private boolean pinned;
    @ColumnInfo(name="publish")
    private boolean publish;

    Thread(@NonNull ThreadStatus status, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull Kind kind, @NonNull Date date, long thread) {
        this.thread = thread;
        this.senderPid = senderPid;
        this.senderAlias = senderAlias;
        this.senderKey = senderKey;
        this.sesKey = sesKey;
        this.kind = kind;
        this.expireDate = THREADS.getOffsetYearDate(-20);
        this.status = status;
        this.readOnly = false;
        this.markedFlag = false;
        this.date = date;
        this.mimeType = "text/plain";
        this.pinned = false;
        this.publish = false;
    }

    public boolean isPublish() {
        return this.publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public static Thread createThread(@NonNull ThreadStatus threadStatus, @NonNull PID senderPid, @NonNull String senderAlias, @NonNull String senderKey, @NonNull String sesKey, @NonNull Kind kind, @NonNull Date date, long thread) {
        Preconditions.checkNotNull((Object)((Object)threadStatus));
        Preconditions.checkNotNull((Object)senderPid);
        Preconditions.checkNotNull((Object)senderAlias);
        Preconditions.checkNotNull((Object)senderKey);
        Preconditions.checkNotNull((Object)sesKey);
        Preconditions.checkNotNull((Object)((Object)kind));
        Preconditions.checkNotNull((Object)date);
        return new Thread(threadStatus, senderPid, senderAlias, senderKey, sesKey, kind, date, thread);
    }

    public boolean isPinned() {
        return this.pinned;
    }

    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    public long getIdx() {
        return this.idx;
    }

    void setIdx(long idx) {
        this.idx = idx;
    }

    @NonNull
    public String getSenderBox() {
        return AddressType.getAddress(this.getSenderPid(), AddressType.INBOX);
    }

    @NonNull
    public String getSenderKey() {
        return this.senderKey;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(@NonNull String mimeType) {
        this.mimeType = mimeType;
    }

    @NonNull
    public PID getSenderPid() {
        return this.senderPid;
    }

    @NonNull
    public Date getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(@NonNull Date expireDate) {
        this.expireDate = expireDate;
    }

    @NonNull
    public ThreadStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NonNull ThreadStatus status) {
        Preconditions.checkNotNull((Object)((Object)status));
        this.status = status;
    }

    @NonNull
    public Kind getKind() {
        return this.kind;
    }

    @NonNull
    public Members getMembers() {
        return this.members;
    }

    public void setMembers(@NonNull Members members) {
        this.members = members;
    }

    public boolean addMember(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.members.add(pid);
    }

    public boolean removeMember(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        return this.members.remove(pid);
    }

    public boolean sameThread(@NonNull Thread o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return Objects.equals(this.cid, o.getCid()) && Objects.equals(this.senderPid, o.getSenderPid()) && Objects.equals(this.image, o.getImage()) && Objects.equals(this.date, o.getDate());
    }

    public boolean sameContent(@NonNull Thread o) {
        Preconditions.checkNotNull((Object)o);
        if (this == o) {
            return true;
        }
        return this.unreadNotes == o.getUnreadNotes() && this.markedFlag == o.getMarkedFlag() && this.status == o.getStatus() && this.pinned == o.isPinned() && this.publish == o.isPublish() && Objects.equals(this.cid, o.getCid()) && Objects.equals(this.senderAlias, o.getSenderAlias()) && Objects.equals(this.image, o.getImage()) && Objects.equals(this.date, o.getDate());
    }

    @Nullable
    public CID getImage() {
        return this.image;
    }

    public void setImage(@Nullable CID image) {
        this.image = image;
    }

    public boolean areItemsTheSame(@NonNull Thread thread) {
        Preconditions.checkNotNull((Object)thread);
        return this.idx == thread.getIdx();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Thread thread = (Thread)o;
        return this.getIdx() == thread.getIdx();
    }

    public int hashCode() {
        return Objects.hash(this.getIdx());
    }

    @Nullable
    public CID getCid() {
        return this.cid;
    }

    public void setCid(@Nullable CID cid) {
        this.cid = cid;
    }

    @NonNull
    public String getSenderAlias() {
        return this.senderAlias;
    }

    public void setSenderAlias(@NonNull String senderAlias) {
        Preconditions.checkNotNull((Object)senderAlias);
        this.senderAlias = senderAlias;
    }

    public boolean getMarkedFlag() {
        return this.markedFlag;
    }

    public void setMarkedFlag(boolean markedFlag) {
        this.markedFlag = markedFlag;
    }

    public int getUnreadNotes() {
        return this.unreadNotes;
    }

    public void setUnreadNotes(int unreadNotes) {
        this.unreadNotes = unreadNotes;
    }

    public long getThread() {
        return this.thread;
    }

    @NonNull
    public String getSesKey() {
        return this.sesKey;
    }

    public void increaseUnreadMessagesNumber() {
        ++this.unreadNotes;
    }

    @NonNull
    public Date getDate() {
        return this.date;
    }

    public void setDate(@NonNull Date date) {
        Preconditions.checkNotNull((Object)date);
        this.date = date;
    }

    @Deprecated
    boolean isReadOnly() {
        return this.readOnly;
    }

    @Deprecated
    void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isEncrypted() {
        return !this.sesKey.isEmpty();
    }
}

