/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Converter;
import threads.core.api.Kind;
import threads.core.api.Note;
import threads.core.api.NoteDao;
import threads.core.api.NoteStatus;
import threads.core.api.NoteType;
import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

public final class NoteDao_Impl
implements NoteDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfNote;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfNote;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfNote;
    private final SharedSQLiteStatement __preparedStmtOfSetNoteStatus;
    private final SharedSQLiteStatement __preparedStmtOfSetNoteStatus_1;
    private final SharedSQLiteStatement __preparedStmtOfSetCid;
    private final SharedSQLiteStatement __preparedStmtOfSetSenderAlias;
    private final SharedSQLiteStatement __preparedStmtOfSetSenderAlias_1;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;
    private final SharedSQLiteStatement __preparedStmtOfSetMimeType;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetImage;

    public NoteDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfNote = new EntityInsertionAdapter<Note>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Note`(`senderPid`,`senderKey`,`sesKey`,`kind`,`thread`,`noteType`,`mimeType`,`date`,`senderAlias`,`idx`,`cid`,`status`,`image`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,?,?,?,?,?,nullif(?, 0),?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Note value) {
                String _tmp = Converter.toString(value.getSenderPid());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getSenderKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSenderKey());
                }
                if (value.getSesKey() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getSesKey());
                }
                Integer _tmp_1 = Kind.toInteger(value.getKind());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp_1.intValue());
                }
                String _tmp_2 = Converter.toString(value.getThread());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                Integer _tmp_3 = NoteType.toInteger(value.getNoteType());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp_3.intValue());
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMimeType());
                }
                Long _tmp_4 = Converter.toLong(value.getDate());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, _tmp_4.longValue());
                }
                if (value.getSenderAlias() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getSenderAlias());
                }
                stmt.bindLong(10, value.getIdx());
                String _tmp_5 = Converter.toString(value.getCid());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                Integer _tmp_6 = NoteStatus.toInteger(value.getStatus());
                if (_tmp_6 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)_tmp_6.intValue());
                }
                String _tmp_7 = Converter.toString(value.getImage());
                if (_tmp_7 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_7);
                }
                String _tmp_8 = Additionals.toString(value.getAdditionals());
                if (_tmp_8 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_8);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getBundle());
                }
                stmt.bindLong(17, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfNote = new EntityDeletionOrUpdateAdapter<Note>(__db){

            public String createQuery() {
                return "DELETE FROM `Note` WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Note value) {
                stmt.bindLong(1, value.getIdx());
            }
        };
        this.__updateAdapterOfNote = new EntityDeletionOrUpdateAdapter<Note>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Note` SET `senderPid` = ?,`senderKey` = ?,`sesKey` = ?,`kind` = ?,`thread` = ?,`noteType` = ?,`mimeType` = ?,`date` = ?,`senderAlias` = ?,`idx` = ?,`cid` = ?,`status` = ?,`image` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Note value) {
                String _tmp = Converter.toString(value.getSenderPid());
                if (_tmp == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, _tmp);
                }
                if (value.getSenderKey() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getSenderKey());
                }
                if (value.getSesKey() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getSesKey());
                }
                Integer _tmp_1 = Kind.toInteger(value.getKind());
                if (_tmp_1 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindLong(4, (long)_tmp_1.intValue());
                }
                String _tmp_2 = Converter.toString(value.getThread());
                if (_tmp_2 == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, _tmp_2);
                }
                Integer _tmp_3 = NoteType.toInteger(value.getNoteType());
                if (_tmp_3 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindLong(6, (long)_tmp_3.intValue());
                }
                if (value.getMimeType() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getMimeType());
                }
                Long _tmp_4 = Converter.toLong(value.getDate());
                if (_tmp_4 == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindLong(8, _tmp_4.longValue());
                }
                if (value.getSenderAlias() == null) {
                    stmt.bindNull(9);
                } else {
                    stmt.bindString(9, value.getSenderAlias());
                }
                stmt.bindLong(10, value.getIdx());
                String _tmp_5 = Converter.toString(value.getCid());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                Integer _tmp_6 = NoteStatus.toInteger(value.getStatus());
                if (_tmp_6 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindLong(12, (long)_tmp_6.intValue());
                }
                String _tmp_7 = Converter.toString(value.getImage());
                if (_tmp_7 == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, _tmp_7);
                }
                String _tmp_8 = Additionals.toString(value.getAdditionals());
                if (_tmp_8 == null) {
                    stmt.bindNull(14);
                } else {
                    stmt.bindString(14, _tmp_8);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(15);
                } else {
                    stmt.bindString(15, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(16);
                } else {
                    stmt.bindString(16, value.getBundle());
                }
                stmt.bindLong(17, value.getTimestamp());
                stmt.bindLong(18, value.getIdx());
            }
        };
        this.__preparedStmtOfSetNoteStatus = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET status = ? WHERE idx = ?";
                return "UPDATE Note SET status = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetNoteStatus_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET status = ? WHERE status = ?";
                return "UPDATE Note SET status = ? WHERE status = ?";
            }
        };
        this.__preparedStmtOfSetCid = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET cid = ? WHERE idx = ?";
                return "UPDATE Note SET cid = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetSenderAlias = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET senderAlias = ?  WHERE idx = ?";
                return "UPDATE Note SET senderAlias = ?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetSenderAlias_1 = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET senderAlias = ?  WHERE senderPid = ?";
                return "UPDATE Note SET senderAlias = ?  WHERE senderPid = ?";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET hash = ? WHERE idx = ?";
                return "UPDATE Note SET hash = ? WHERE idx = ?";
            }
        };
        this.__preparedStmtOfSetMimeType = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET mimeType =?  WHERE idx = ?";
                return "UPDATE Note SET mimeType =?  WHERE idx = ?";
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Note";
                return "DELETE FROM Note";
            }
        };
        this.__preparedStmtOfSetImage = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE Note SET image = ? WHERE idx = ?";
                return "UPDATE Note SET image = ? WHERE idx = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insertNote(Note note) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfNote.insertAndReturnId((Object)note);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertNotes(Note ... note) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfNote.insert((Object[])note);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void removeNote(Note notification) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfNote.handle((Object)notification);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateNote(Note notification) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfNote.handle((Object)notification);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoteStatus(long idx, NoteStatus status) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetNoteStatus.acquire();
        int _argIndex = 1;
        Integer _tmp = NoteStatus.toInteger(status);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetNoteStatus.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNoteStatus(NoteStatus oldStatus, NoteStatus newStatus) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetNoteStatus_1.acquire();
        int _argIndex = 1;
        Integer _tmp = NoteStatus.toInteger(newStatus);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer _tmp_1 = NoteStatus.toInteger(oldStatus);
        if (_tmp_1 == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetNoteStatus_1.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCid(long idx, CID cid) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetCid.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetCid.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSenderAlias(long idx, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetSenderAlias.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetSenderAlias.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSenderAlias(PID pid, String alias) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetSenderAlias_1.acquire();
        int _argIndex = 1;
        if (alias == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, alias);
        }
        _argIndex = 2;
        String _tmp = Converter.toString(pid);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetSenderAlias_1.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(long idx, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMimeType(long idx, String mimeType) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetMimeType.acquire();
        int _argIndex = 1;
        if (mimeType == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, mimeType);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetMimeType.release(_stmt);
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setImage(long idx, CID image) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetImage.acquire();
        int _argIndex = 1;
        String _tmp = Converter.toString(image);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        _stmt.bindLong(_argIndex, idx);
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetImage.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Note> getNotesByKindAndStatus(Kind kind, NoteStatus status) {
        String _sql = "SELECT * FROM Note WHERE kind LIKE ? AND status LIKE ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note WHERE kind LIKE ? AND status LIKE ?", (int)2);
        int _argIndex = 1;
        Integer _tmp = Kind.toInteger(kind);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        Integer _tmp_1 = NoteStatus.toInteger(status);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp_1.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp_2 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_2);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_3);
                String _tmp_4 = _cursor.getString(_cursorIndexOfThread);
                CID _tmpThread = Converter.toCID(_tmp_4);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                NoteType _tmpNoteType = NoteType.toNoteType(_tmp_5);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                Long _tmp_6 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_6);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_7 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_7);
                Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_8 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_8);
                _item.setCid(_tmpCid);
                String _tmp_9 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_9);
                _item.setImage(_tmpImage);
                String _tmp_10 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_10);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Note> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHash(long idx) {
        String _sql = "SELECT hash FROM Note WHERE idx = ? ";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT hash FROM Note WHERE idx = ? ", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Note> getNotes() {
        String _sql = "SELECT * FROM Note";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfThread);
                CID _tmpThread = Converter.toCID(_tmp_2);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                NoteType _tmpNoteType = NoteType.toNoteType(_tmp_3);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                Long _tmp_4 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_4);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_5);
                Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_6);
                _item.setCid(_tmpCid);
                String _tmp_7 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_7);
                _item.setImage(_tmpImage);
                String _tmp_8 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_8);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Note> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Note> getNotesByCid(CID cid) {
        String _sql = "SELECT * FROM Note WHERE cid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note WHERE cid = ?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfThread);
                CID _tmpThread = Converter.toCID(_tmp_3);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                NoteType _tmpNoteType = NoteType.toNoteType(_tmp_4);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                Long _tmp_5 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_5);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_6);
                Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item.setCid(_tmpCid);
                String _tmp_8 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_8);
                _item.setImage(_tmpImage);
                String _tmp_9 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_9);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Note> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Note getNoteByIdx(long idx) {
        String _sql = "SELECT * FROM Note WHERE idx =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note WHERE idx =?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Note _result;
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmp = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_1);
                String _tmp_2 = _cursor.getString(_cursorIndexOfThread);
                CID _tmpThread = Converter.toCID(_tmp_2);
                Integer _tmp_3 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                NoteType _tmpNoteType = NoteType.toNoteType(_tmp_3);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                Long _tmp_4 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_4);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_5 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_5);
                _result = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _result.setIdx(_tmpIdx);
                String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_6);
                _result.setCid(_tmpCid);
                String _tmp_7 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_7);
                _result.setImage(_tmpImage);
                String _tmp_8 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_8);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Note note = _result;
            return note;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Note> getNotesByThread(CID thread) {
        String _sql = "SELECT * FROM Note WHERE thread =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note WHERE thread =?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(thread);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfThread);
                CID _tmpThread = Converter.toCID(_tmp_3);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                NoteType _tmpNoteType = NoteType.toNoteType(_tmp_4);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                Long _tmp_5 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_5);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_6);
                Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item.setCid(_tmpCid);
                String _tmp_8 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_8);
                _item.setImage(_tmpImage);
                String _tmp_9 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_9);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Note> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Note> getNotesByDate(Date date) {
        String _sql = "SELECT * FROM Note WHERE date =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note WHERE date =?", (int)1);
        int _argIndex = 1;
        Long _tmp = Converter.toLong(date);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, _tmp.longValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfThread);
                CID _tmpThread = Converter.toCID(_tmp_3);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                NoteType _tmpNoteType = NoteType.toNoteType(_tmp_4);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                Long _tmp_5 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_5);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_6);
                Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item.setCid(_tmpCid);
                String _tmp_8 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_8);
                _item.setImage(_tmpImage);
                String _tmp_9 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_9);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Note> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Note>> getLiveDataNotesByThread(CID thread) {
        String _sql = "SELECT * FROM Note WHERE thread =?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note WHERE thread =?", (int)1);
        int _argIndex = 1;
        String _tmp = Converter.toString(thread);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Note"}, false, (Callable)new Callable<List<Note>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Note> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)NoteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
                    int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
                    int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
                    int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
                    int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
                    int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                        PID _tmpSenderPid = Converter.toPID(_tmp_1);
                        String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                        String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                        Integer _tmp_2 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                        Kind _tmpKind = Kind.toKind(_tmp_2);
                        String _tmp_3 = _cursor.getString(_cursorIndexOfThread);
                        CID _tmpThread = Converter.toCID(_tmp_3);
                        Integer _tmp_4 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                        NoteType _tmpNoteType = NoteType.toNoteType(_tmp_4);
                        String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                        Long _tmp_5 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                        Date _tmpDate = Converter.toDate(_tmp_5);
                        String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                        Integer _tmp_6 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_6);
                        Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                        CID _tmpCid = Converter.toCID(_tmp_7);
                        _item.setCid(_tmpCid);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_8);
                        _item.setImage(_tmpImage);
                        String _tmp_9 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_9);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _item.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Note> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<Note>> getLiveDataNotes() {
        String _sql = "SELECT * FROM Note";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Note"}, false, (Callable)new Callable<List<Note>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Note> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)NoteDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
                    int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
                    int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
                    int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
                    int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
                    int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
                    int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmp = _cursor.getString(_cursorIndexOfSenderPid);
                        PID _tmpSenderPid = Converter.toPID(_tmp);
                        String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                        String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                        Integer _tmp_1 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                        Kind _tmpKind = Kind.toKind(_tmp_1);
                        String _tmp_2 = _cursor.getString(_cursorIndexOfThread);
                        CID _tmpThread = Converter.toCID(_tmp_2);
                        Integer _tmp_3 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                        NoteType _tmpNoteType = NoteType.toNoteType(_tmp_3);
                        String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                        Long _tmp_4 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                        Date _tmpDate = Converter.toDate(_tmp_4);
                        String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                        Integer _tmp_5 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                        NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_5);
                        Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        String _tmp_6 = _cursor.getString(_cursorIndexOfCid);
                        CID _tmpCid = Converter.toCID(_tmp_6);
                        _item.setCid(_tmpCid);
                        String _tmp_7 = _cursor.getString(_cursorIndexOfImage);
                        CID _tmpImage = Converter.toCID(_tmp_7);
                        _item.setImage(_tmpImage);
                        String _tmp_8 = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_8);
                        _item.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _item.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _item.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        _result.add(_item);
                    }
                    ArrayList<Note> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMimeType(long idx) {
        String _sql = "SELECT mimeType FROM Note WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT mimeType FROM Note WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Note> getNotesByType(NoteType type) {
        String _sql = "SELECT * FROM Note WHERE noteType =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Note WHERE noteType =?", (int)1);
        int _argIndex = 1;
        Integer _tmp = NoteType.toInteger(type);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindLong(_argIndex, (long)_tmp.intValue());
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfSenderPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderPid");
            int _cursorIndexOfSenderKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderKey");
            int _cursorIndexOfSesKey = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sesKey");
            int _cursorIndexOfKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"kind");
            int _cursorIndexOfThread = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"thread");
            int _cursorIndexOfNoteType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"noteType");
            int _cursorIndexOfMimeType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mimeType");
            int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
            int _cursorIndexOfSenderAlias = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"senderAlias");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            int _cursorIndexOfCid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"cid");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfImage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"image");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Note> _result = new ArrayList<Note>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmp_1 = _cursor.getString(_cursorIndexOfSenderPid);
                PID _tmpSenderPid = Converter.toPID(_tmp_1);
                String _tmpSenderKey = _cursor.getString(_cursorIndexOfSenderKey);
                String _tmpSesKey = _cursor.getString(_cursorIndexOfSesKey);
                Integer _tmp_2 = _cursor.isNull(_cursorIndexOfKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfKind));
                Kind _tmpKind = Kind.toKind(_tmp_2);
                String _tmp_3 = _cursor.getString(_cursorIndexOfThread);
                CID _tmpThread = Converter.toCID(_tmp_3);
                Integer _tmp_4 = _cursor.isNull(_cursorIndexOfNoteType) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfNoteType));
                NoteType _tmpNoteType = NoteType.toNoteType(_tmp_4);
                String _tmpMimeType = _cursor.getString(_cursorIndexOfMimeType);
                Long _tmp_5 = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                Date _tmpDate = Converter.toDate(_tmp_5);
                String _tmpSenderAlias = _cursor.getString(_cursorIndexOfSenderAlias);
                Integer _tmp_6 = _cursor.isNull(_cursorIndexOfStatus) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfStatus));
                NoteStatus _tmpStatus = NoteStatus.toStatus(_tmp_6);
                Note _item = new Note(_tmpThread, _tmpSenderPid, _tmpSenderAlias, _tmpSenderKey, _tmpSesKey, _tmpMimeType, _tmpStatus, _tmpKind, _tmpNoteType, _tmpDate);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                String _tmp_7 = _cursor.getString(_cursorIndexOfCid);
                CID _tmpCid = Converter.toCID(_tmp_7);
                _item.setCid(_tmpCid);
                String _tmp_8 = _cursor.getString(_cursorIndexOfImage);
                CID _tmpImage = Converter.toCID(_tmp_8);
                _item.setImage(_tmpImage);
                String _tmp_9 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_9);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Note> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int references(CID cid) {
        String _sql = "SELECT COUNT(idx) FROM Note WHERE cid =? OR image =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT COUNT(idx) FROM Note WHERE cid =? OR image =?", (int)2);
        int _argIndex = 1;
        String _tmp = Converter.toString(cid);
        if (_tmp == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp);
        }
        _argIndex = 2;
        String _tmp_1 = Converter.toString(cid);
        if (_tmp_1 == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, _tmp_1);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _result = _cursor.moveToFirst() ? _cursor.getInt(0) : 0;
            int n = _result;
            return n;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NoteStatus getNoteStatus(long idx) {
        String _sql = "SELECT status FROM Note WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT status FROM Note WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            NoteStatus _result;
            if (_cursor.moveToFirst()) {
                Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                _result = NoteStatus.toStatus(_tmp);
            } else {
                _result = null;
            }
            NoteStatus noteStatus = _result;
            return noteStatus;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NoteType getNoteType(long idx) {
        String _sql = "SELECT noteType FROM Note WHERE idx = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT noteType FROM Note WHERE idx = ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, idx);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            NoteType _result;
            if (_cursor.moveToFirst()) {
                Integer _tmp = _cursor.isNull(0) ? null : Integer.valueOf(_cursor.getInt(0));
                _result = NoteType.toNoteType(_tmp);
            } else {
                _result = null;
            }
            NoteType noteType = _result;
            return noteType;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNotesStatus(NoteStatus status, long ... idxs) {
        this.__db.assertNotSuspendingTransaction();
        StringBuilder _stringBuilder = StringUtil.newStringBuilder();
        _stringBuilder.append("UPDATE Note SET status = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" WHERE idx IN(");
        int _inputSize = idxs.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        SupportSQLiteStatement _stmt = this.__db.compileStatement(_sql);
        int _argIndex = 1;
        Integer _tmp = NoteStatus.toInteger(status);
        if (_tmp == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindLong(_argIndex, (long)_tmp.intValue());
        }
        _argIndex = 2;
        for (long _item : idxs) {
            _stmt.bindLong(_argIndex, _item);
            ++_argIndex;
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }
}

