package threads.core.api;

import androidx.annotation.NonNull;
import androidx.room.TypeConverter;

import static androidx.core.util.Preconditions.checkNotNull;

@Deprecated
public enum UserStatus {

    // BLOCKED is deprecated TODO (delete later 11.07.2017 -> delete 30.09.2017)

    @Deprecated
    OFFLINE(0),
    @Deprecated
    BLOCKED(1),
    @Deprecated
    ONLINE(2),
    @Deprecated
    DIALING(3);
    @NonNull
    private final Integer code;

    UserStatus(@NonNull Integer code) {
        checkNotNull(code);
        this.code = code;
    }

    @TypeConverter
    public static UserStatus toUserStatus(Integer status) {
        checkNotNull(status);
        if (status.equals(UserStatus.OFFLINE.getCode())) {
            return UserStatus.OFFLINE;
        } else if (status.equals(UserStatus.ONLINE.getCode())) {
            return UserStatus.ONLINE;
        } else if (status.equals(UserStatus.BLOCKED.getCode())) {
            return UserStatus.BLOCKED;
        } else if (status.equals(UserStatus.DIALING.getCode())) {
            return UserStatus.DIALING;
        } else {
            throw new IllegalArgumentException("Could not recognize status");
        }
    }

    @TypeConverter
    public static Integer toInteger(UserStatus status) {
        checkNotNull(status);
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return code;
    }
}
