/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Server;
import threads.core.api.User;
import threads.iota.Entity;
import threads.ipfs.api.PID;

public class ServerDecoder {
    private static final String TAG = ServerDecoder.class.getSimpleName();

    @Nullable
    public static Server convert(@NonNull Entity entity, @NonNull User owner) {
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)owner);
        Gson gson = new Gson();
        Content content = (Content)gson.fromJson(entity.getContent(), Content.class);
        Server server = ServerDecoder.convert(content, owner.getPID());
        if (server != null) {
            server.setHash(entity.getHash());
        }
        return server;
    }

    @Nullable
    public static Server convert(@NonNull Content content, @NonNull PID owner) {
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)owner);
        try {
            String protocol = (String)content.get("protocol");
            Preconditions.checkNotNull((Object)protocol);
            String alias = (String)content.get("alias");
            Preconditions.checkNotNull((Object)alias);
            String host = (String)content.get("host");
            Preconditions.checkNotNull((Object)host);
            String port = (String)content.get("port");
            Preconditions.checkNotNull((Object)port);
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            Server server = new Server(protocol, host, Integer.valueOf(port), alias);
            if (!additions.isEmpty()) {
                server.setExternalAdditions(Additionals.toHashMap(additions));
            }
            return server;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

