package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.TypeConverters;
import androidx.room.Update;

import java.util.Date;
import java.util.List;

import threads.ipfs.api.CID;
import threads.ipfs.api.PID;

@Dao
public interface NoteDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    long insertNote(Note note);


    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertNotes(Note... note);

    @Query("SELECT * FROM Note WHERE kind LIKE :kind AND status LIKE :status")
    @TypeConverters({Kind.class, NoteStatus.class})
    List<Note> getNotesByKindAndStatus(Kind kind, NoteStatus status);

    @Query("SELECT hash FROM Note WHERE idx = :idx ")
    String getHash(long idx);

    @Query("UPDATE Note SET status = :status WHERE idx = :idx")
    @TypeConverters({NoteStatus.class})
    void setNoteStatus(long idx, NoteStatus status);

    @Query("UPDATE Note SET status = :status WHERE idx IN(:idxs)")
    @TypeConverters({NoteStatus.class})
    void setNotesStatus(NoteStatus status, long... idxs);

    @Query("UPDATE Note SET status = :newStatus WHERE status = :oldStatus")
    @TypeConverters({NoteStatus.class})
    void setNoteStatus(NoteStatus oldStatus, NoteStatus newStatus);

    @Query("UPDATE Note SET cid = :cid WHERE idx = :idx")
    @TypeConverters({Converter.class})
    void setCid(long idx, CID cid);

    @Query("UPDATE Note SET senderAlias = :alias  WHERE idx = :idx")
    void setSenderAlias(long idx, String alias);

    @Query("UPDATE Note SET senderAlias = :alias  WHERE senderPid = :pid")
    @TypeConverters(Converter.class)
    void setSenderAlias(PID pid, String alias);


    @Query("UPDATE Note SET hash = :hash WHERE idx = :idx")
    void setHash(long idx, String hash);

    @Query("SELECT * FROM Note")
    List<Note> getNotes();

    @Query("UPDATE Note SET mimeType =:mimeType  WHERE idx = :idx")
    void setMimeType(long idx, String mimeType);

    @Query("SELECT * FROM Note WHERE cid = :cid")
    @TypeConverters({Converter.class})
    List<Note> getNotesByCid(CID cid);

    @Query("SELECT * FROM Note WHERE idx =:idx")
    Note getNoteByIdx(long idx);

    @Query("SELECT * FROM Note WHERE thread =:thread")
    @TypeConverters({Converter.class})
    List<Note> getNotesByThread(CID thread);

    @Query("SELECT * FROM Note WHERE date =:date")
    @TypeConverters({Converter.class})
    List<Note> getNotesByDate(Date date);

    @Query("SELECT * FROM Note WHERE thread =:thread")
    @TypeConverters({Converter.class})
    LiveData<List<Note>> getLiveDataNotesByThread(CID thread);

    @Query("SELECT * FROM Note")
    LiveData<List<Note>> getLiveDataNotes();

    @Update(onConflict = OnConflictStrategy.REPLACE)
    void updateNote(Note notification);

    @Delete
    void removeNote(Note notification);

    @Query("SELECT mimeType FROM Note WHERE idx = :idx")
    String getMimeType(long idx);

    @Query("DELETE FROM Note")
    void clear();

    @Query("SELECT * FROM Note WHERE noteType =:type")
    @TypeConverters({NoteType.class})
    List<Note> getNotesByType(NoteType type);


    @Query("SELECT COUNT(idx) FROM Note WHERE cid =:cid OR image =:cid")
    @TypeConverters({Converter.class})
    int references(CID cid);

    @Query("UPDATE Note SET image = :image WHERE idx = :idx")
    @TypeConverters({Converter.class})
    void setImage(long idx, CID image);

    @Query("SELECT status FROM Note WHERE idx = :idx")
    @TypeConverters({NoteStatus.class})
    NoteStatus getNoteStatus(long idx);

    @Query("SELECT noteType FROM Note WHERE idx = :idx")
    @TypeConverters({NoteType.class})
    NoteType getNoteType(long idx);
}
