/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import org.iota.jota.utils.TrytesConverter;
import threads.iota.IOTA;
import threads.ipfs.api.PID;

public enum AddressType {
    INBOX,
    PEER,
    NOTIFICATION;


    @NonNull
    public static String getAddress(@NonNull PID pid, @NonNull AddressType addressType) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)((Object)addressType));
        String address = TrytesConverter.asciiToTrytes((String)pid.getPid());
        Preconditions.checkNotNull((Object)address);
        switch (addressType) {
            case PEER: {
                return IOTA.addChecksum((String)address.substring(0, 81));
            }
            case INBOX: {
                return IOTA.addChecksum((String)address.substring(address.length() - 81));
            }
            case NOTIFICATION: {
                StringBuilder notification = new StringBuilder();
                notification.append(address.substring(address.length() - 81));
                notification = notification.reverse();
                return IOTA.addChecksum((String)notification.toString());
            }
        }
        throw new RuntimeException("Not supported address type");
    }
}

