package threads.core.api;

import androidx.annotation.NonNull;
import androidx.room.TypeConverter;

import static androidx.core.util.Preconditions.checkNotNull;

public enum ThreadStatus {
    OFFLINE(0),    // Thread is offline (init state, data not locally available IPFS)
    ONLINE(1),     // Thread is online (data not locally available IPFS)
    REQUEST(2),    // Thread request
    EXPIRED(3),    // Thread will be expired
    DELETING(4),   // Thread will be deleted
    ERROR(5),      // Thread is in error state
    LEACHING(6),   // Thread will be loaded to local IPFS (both external or internal)
    @Deprecated
    PUBLISHING(7), // Thread note is publishing (IPFS)
    SEEDING(8);    // Thread note is seeding (IPFS, data is locally available IPFS)

    @NonNull
    private final Integer code;

    ThreadStatus(@NonNull Integer code) {
        checkNotNull(code);
        this.code = code;
    }

    @TypeConverter
    public static ThreadStatus toThreadStatus(Integer status) {
        checkNotNull(status);

        if (status.equals(ThreadStatus.OFFLINE.getCode())) {
            return ThreadStatus.OFFLINE;
        } else if (status.equals(ThreadStatus.ONLINE.getCode())) {
            return ThreadStatus.ONLINE;
        } else if (status.equals(ThreadStatus.REQUEST.getCode())) {
            return ThreadStatus.REQUEST;
        } else if (status.equals(ThreadStatus.EXPIRED.getCode())) {
            return ThreadStatus.EXPIRED;
        } else if (status.equals(ThreadStatus.DELETING.getCode())) {
            return ThreadStatus.DELETING;
        } else if (status.equals(ThreadStatus.ERROR.getCode())) {
            return ThreadStatus.ERROR;
        } else if (status.equals(ThreadStatus.LEACHING.getCode())) {
            return ThreadStatus.LEACHING;
        } else if (status.equals(ThreadStatus.PUBLISHING.getCode())) {
            return ThreadStatus.PUBLISHING;
        } else if (status.equals(ThreadStatus.SEEDING.getCode())) {
            return ThreadStatus.SEEDING;
        } else {
            throw new IllegalArgumentException("Could not recognize status");
        }
    }

    @TypeConverter
    public static Integer toInteger(ThreadStatus status) {
        checkNotNull(status);
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return code;
    }
}
