package threads.core.api;

import androidx.annotation.NonNull;
import androidx.room.TypeConverter;

import static androidx.core.util.Preconditions.checkNotNull;


public enum NoteStatus {
    OFFLINE(0),    // KIND::OUT note just created
    @Deprecated
    SENDING(1),    // KIND::OUT note is sending (IOTA and IPFS local)
    PUBLISHING(2), // KIND::OUT note is publishing (IPFS)
    ONLINE(3),     // KIND::IN and KIND::OUT note is available for others
    SEEDING(4),    // KIND::IN and KIND::OUT note is available for others
    DELETING(5),   // KIND::IN and KIND::OUT note will be deleted
    EXPIRED(6),    // KIND::IN and KIND::OUT note is in status expired
    LEACHING(7),   // KIND::IN note will be loaded to IPFS
    ERROR(8);      // KIND::IN and KIND::OUT note is in error state
    @NonNull
    private final Integer code;

    NoteStatus(@NonNull Integer code) {
        checkNotNull(code);
        this.code = code;
    }

    @TypeConverter
    public static NoteStatus toStatus(Integer status) {
        checkNotNull(status);
        if (status.equals(NoteStatus.SEEDING.getCode())) {
            return NoteStatus.SEEDING;
        } else if (status.equals(NoteStatus.SENDING.getCode())) {
            return NoteStatus.SENDING;
        } else if (status.equals(NoteStatus.PUBLISHING.getCode())) {
            return NoteStatus.PUBLISHING;
        } else if (status.equals(NoteStatus.ONLINE.getCode())) {
            return NoteStatus.ONLINE;
        } else if (status.equals(NoteStatus.OFFLINE.getCode())) {
            return NoteStatus.OFFLINE;
        } else if (status.equals(NoteStatus.DELETING.getCode())) {
            return NoteStatus.DELETING;
        } else if (status.equals(NoteStatus.EXPIRED.getCode())) {
            return NoteStatus.EXPIRED;
        } else if (status.equals(NoteStatus.LEACHING.getCode())) {
            return NoteStatus.LEACHING;
        } else if (status.equals(NoteStatus.ERROR.getCode())) {
            return NoteStatus.ERROR;
        } else {
            throw new IllegalArgumentException("Could not recognize status");
        }
    }

    @TypeConverter
    public static Integer toInteger(NoteStatus status) {
        checkNotNull(status);
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return code;
    }
}
