/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import threads.core.Network;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Peer;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.ipfs.api.PeerInfo;

public class GatewayService {
    public static final String TAG = GatewayService.class.getSimpleName();

    public static int evaluatePeers(@NonNull Context context, boolean pubsubs) {
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Preconditions.checkNotNull((Object)ipfs);
        List peers = ipfs.swarmPeers();
        int size = peers.size();
        for (threads.ipfs.api.Peer peer : peers) {
            if (pubsubs) {
                if (!peer.isAutonat() && !peer.isRelay() && !peer.isMeshSub() && !peer.isFloodSub()) continue;
                GatewayService.storePeer(context, peer);
                continue;
            }
            if (!peer.isAutonat() && !peer.isRelay()) continue;
            GatewayService.storePeer(context, peer);
        }
        return size;
    }

    public static synchronized List<Peer> getRelayPeers(@NonNull Context context, @NonNull String tag, int numRelays, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numRelays >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Peer> result = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return result;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            peers.sort(threads.ipfs.api.Peer::compareTo);
            for (threads.ipfs.api.Peer peer : peers) {
                if (result.size() == numRelays) break;
                if (!peer.isRelay()) continue;
                if (ipfs.isConnected(peer.getPid())) {
                    if (!tag.isEmpty()) {
                        ipfs.protectPeer(peer.getPid(), tag);
                    }
                    result.add(GatewayService.storePeer(context, peer));
                    continue;
                }
                if (!ipfs.swarmConnect(peer, timeout)) continue;
                if (!tag.isEmpty()) {
                    ipfs.protectPeer(peer.getPid(), tag);
                }
                result.add(GatewayService.storePeer(context, peer));
            }
        }
        return result;
    }

    private static Peer storePeer(@NonNull Context context, @NonNull threads.ipfs.api.Peer peer) {
        int rating = 0;
        try {
            double latency = peer.getLatency();
            if (latency < 1000.0) {
                rating = (int)(1000.0 - latency);
            }
        }
        catch (Throwable latency) {
            // empty catch block
        }
        try {
            PeerInfo info;
            int timeout = 5;
            IPFS ipfs = Singleton.getInstance(context).getIpfs();
            if (ipfs != null && (info = ipfs.id(peer, timeout)) != null) {
                String protocol = info.getProtocolVersion();
                String agent = info.getAgentVersion();
                rating = protocol != null && protocol.equals("ipfs/0.1.0") ? (rating += 100) : (rating -= 100);
                if (agent != null) {
                    if (agent.startsWith("go-ipfs/0.4.2")) {
                        rating += 100;
                    } else if (agent.startsWith("go-ipfs/0.5")) {
                        rating += 150;
                    }
                }
            }
        }
        catch (Throwable timeout) {
            // empty catch block
        }
        if (rating < 0) {
            rating = 0;
        }
        boolean isPubsub = peer.isFloodSub() || peer.isMeshSub();
        return GatewayService.storePeer(context, peer.getPid(), peer.getMultiAddress(), peer.isRelay(), peer.isAutonat(), isPubsub, rating);
    }

    @NonNull
    public static Peer storePeer(@NonNull Context context, @NonNull PID pid, @NonNull String multiAddress, boolean isRelay, boolean isAutonat, boolean isPubsub, int rating) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        Peer peer = threads.getPeerByPID(pid);
        if (peer != null) {
            peer.setMultiAddress(multiAddress);
            peer.setRelay(isRelay);
            peer.setAutonat(isAutonat);
            peer.setPubsub(isPubsub);
            peer.setRating(rating);
            threads.updatePeer(peer);
            Log.e((String)TAG, (String)("Update Peer  : " + peer.toString()));
        } else {
            peer = threads.createPeer(pid, multiAddress);
            peer.setRelay(isRelay);
            peer.setAutonat(isAutonat);
            peer.setPubsub(isPubsub);
            peer.setRating(rating);
            threads.storePeer(peer);
            Log.e((String)TAG, (String)("Store Peer  : " + peer.toString()));
        }
        return peer;
    }

    public static void connectStoredAutonat(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getAutonatPeers();
            peers.sort(Peer::compareTo);
            for (Peer autonat : peers) {
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Autonat : " + autonat.toString()));
                if (ipfs.isConnected(PID.create((String)autonat.getPid()))) {
                    counter.incrementAndGet();
                    continue;
                }
                String ma = autonat.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + autonat.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    continue;
                }
                if (!Network.isConnectedFast(context)) continue;
                threads.removePeer(autonat);
            }
        }
    }

    public static void connectStoredPubsub(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getPubsubPeers();
            peers.sort(Peer::compareTo);
            for (Peer autonat : peers) {
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Pubsub : " + autonat.toString()));
                if (ipfs.isConnected(PID.create((String)autonat.getPid()))) {
                    counter.incrementAndGet();
                    continue;
                }
                String ma = autonat.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + autonat.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    continue;
                }
                if (!Network.isConnectedFast(context)) continue;
                threads.removePeer(autonat);
            }
        }
    }

    public static void connectStoredRelays(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> peers = threads.getRelayPeers();
            peers.sort(Peer::compareTo);
            for (Peer relay : peers) {
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Relay : " + relay.toString()));
                if (ipfs.isConnected(PID.create((String)relay.getPid()))) {
                    counter.incrementAndGet();
                    continue;
                }
                String ma = relay.getMultiAddress() + "/" + IPFS.Style.p2p.name() + "/" + relay.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    continue;
                }
                if (!Network.isConnectedFast(context)) continue;
                threads.removePeer(relay);
            }
        }
    }
}

