/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.RandomStringUtils;
import threads.core.GatewayService;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Additional;
import threads.core.api.Additionals;
import threads.core.api.Peer;
import threads.core.api.PeerInfo;
import threads.core.api.User;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class IdentityService {
    public static final String TAG = IdentityService.class.getSimpleName();

    @Nullable
    public static ResultInfo publishIdentity(@NonNull Context context, @NonNull String aesKey, @NonNull Map<String, String> params, boolean addIdentity, int numRelays) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull(params);
        Preconditions.checkArgument((numRelays >= 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return null;
        }
        int timeout = 3;
        GatewayService.connectStoredRelays(context, numRelays, timeout);
        THREADS threads = Singleton.getInstance(context).getThreads();
        try {
            PID host = Preferences.getPID(context);
            if (host != null) {
                PeerInfo peer;
                IPFS ipfs;
                String tag = RandomStringUtils.randomAlphabetic((int)10);
                threads.ipfs.api.PeerInfo info = null;
                if (addIdentity && (ipfs = Singleton.getInstance(context).getIpfs()) != null) {
                    info = ipfs.id();
                }
                if ((peer = threads.getPeerInfoByPID(host)) != null) {
                    return IdentityService.updatePeerInfo(context, peer, info, aesKey, params, tag, timeout, numRelays);
                }
                return IdentityService.createPeerInfo(context, info, host, aesKey, params, tag, timeout, numRelays);
            }
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
        }
        return null;
    }

    private static List<String> getMultiAddresses(@NonNull threads.ipfs.api.PeerInfo info) {
        Preconditions.checkNotNull((Object)info);
        ArrayList<String> addresses = new ArrayList<String>();
        for (String address : info.getMultiAddresses()) {
            if (address.startsWith("/ip6/::1/") || address.startsWith("/ip4/127.0.0.1/")) continue;
            addresses.add(address);
        }
        return addresses;
    }

    private static ResultInfo createPeerInfo(@NonNull Context context, @Nullable threads.ipfs.api.PeerInfo info, @NonNull PID user, @NonNull String aesKey, @NonNull Map<String, String> params, @NonNull String tag, int timeout, int numPeers) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        PeerInfo peerInfo = threads.createPeerInfo(user);
        List<Peer> relayPeers = GatewayService.getRelayPeers(context, tag, numPeers, timeout);
        for (Peer peer : relayPeers) {
            peerInfo.addAddress(peer.getPid(), peer.getMultiAddress());
        }
        for (Map.Entry entry : params.entrySet()) {
            peerInfo.addAdditional((String)entry.getKey(), (String)entry.getValue(), false);
        }
        if (info != null) {
            List<String> multiAddresses = IdentityService.getMultiAddresses(info);
            for (String address : multiAddresses) {
                peerInfo.addMultiAddresses(address);
            }
        }
        threads.storePeerInfo(peerInfo);
        return new ResultInfo(peerInfo, tag, IdentityService.insertPeer(context, peerInfo, aesKey));
    }

    private static boolean insertPeer(@NonNull Context context, @NonNull PeerInfo peer, @NonNull String aesKey) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        Preconditions.checkNotNull((Object)iota);
        threads.setHash(peer, null);
        long start = System.currentTimeMillis();
        boolean success = threads.insertPeerInfo(iota, peer, aesKey);
        long time = (System.currentTimeMillis() - start) / 1000L;
        if (success) {
            Singleton.getInstance(context).getConsoleListener().info("Success store peer discovery information: " + time + " [s]");
        } else {
            Singleton.getInstance(context).getConsoleListener().error("Failed store peer discovery information: " + time + " [s]");
        }
        return success;
    }

    public static PeerInfo getPeerInfo(@NonNull Context context, @NonNull PID pid, @NonNull String aesKey, boolean updateUser) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        PeerInfo peerInfo = threads.getPeer(iota, pid, aesKey);
        if (peerInfo != null && updateUser) {
            boolean update = false;
            User user = threads.getUserByPID(pid);
            if (user != null) {
                Additionals additionals = peerInfo.getAdditionals();
                for (String key : additionals.keySet()) {
                    Additional additional = (Additional)additionals.get(key);
                    String value = additional.getValue();
                    user.addAdditional(key, value, true);
                    update = true;
                }
            }
            if (update) {
                threads.updateUser(user);
            }
        }
        return peerInfo;
    }

    private static ResultInfo updatePeerInfo(@NonNull Context context, @NonNull PeerInfo peerInfo, @Nullable threads.ipfs.api.PeerInfo info, @NonNull String aesKey, @NonNull Map<String, String> params, @NonNull String tag, int timeout, int numPeers) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        THREADS threads = Singleton.getInstance(context).getThreads();
        peerInfo.removeAddresses();
        List<Peer> peers = GatewayService.getRelayPeers(context, tag, numPeers, timeout);
        for (Peer peer : peers) {
            peerInfo.addAddress(peer.getPid(), peer.getMultiAddress());
        }
        peerInfo.removeAdditionals();
        for (Map.Entry entry : params.entrySet()) {
            peerInfo.addAdditional((String)entry.getKey(), (String)entry.getValue(), false);
        }
        peerInfo.removeMultiAddresses();
        if (info != null) {
            List<String> multiAddresses = IdentityService.getMultiAddresses(info);
            for (String address : multiAddresses) {
                peerInfo.addMultiAddresses(address);
            }
        }
        threads.updatePeerInfo(peerInfo);
        return new ResultInfo(peerInfo, tag, IdentityService.insertPeer(context, peerInfo, aesKey));
    }

    public static class ResultInfo {
        @NonNull
        private final String tag;
        private final boolean insert;
        @NonNull
        private final PeerInfo peerInfo;

        ResultInfo(@NonNull PeerInfo peerInfo, @NonNull String tag, boolean insert) {
            this.peerInfo = peerInfo;
            this.tag = tag;
            this.insert = insert;
        }

        @NonNull
        public String getTag() {
            return this.tag;
        }

        @NonNull
        public PeerInfo getPeerInfo() {
            return this.peerInfo;
        }

        public boolean isInsert() {
            return this.insert;
        }
    }
}

