/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum Kind {
    IN(0),
    OUT(1);

    @NonNull
    private final Integer code;

    private Kind(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static Kind toKind(Integer type) {
        if (type == null) {
            return null;
        }
        if (type.equals(IN.getCode())) {
            return IN;
        }
        if (type.equals(OUT.getCode())) {
            return OUT;
        }
        throw new IllegalArgumentException("Could not recognize type");
    }

    @TypeConverter
    public static Integer toInteger(Kind type) {
        if (type == null) {
            return null;
        }
        return type.getCode();
    }

    @NonNull
    private Integer getCode() {
        return this.code;
    }
}

