/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum NoteType {
    MESSAGE(1),
    INFO(2),
    DATA(3),
    LINK(4),
    AUDIO(5),
    HTML(6),
    THREAD_REQUEST(7),
    THREAD_LEAVE(8),
    THREAD_JOIN(9),
    THREAD_REJECT(10),
    THREAD_PUBLISH(11),
    CALL(12),
    LOCATION(13),
    CONTACT(14),
    VIDEO_CALL(15);

    @NonNull
    private final Integer code;

    private NoteType(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static NoteType toNoteType(@NonNull Integer type) {
        Preconditions.checkNotNull((Object)type);
        if (type.equals(MESSAGE.getCode())) {
            return MESSAGE;
        }
        if (type.equals(INFO.getCode())) {
            return INFO;
        }
        if (type.equals(DATA.getCode())) {
            return DATA;
        }
        if (type.equals(AUDIO.getCode())) {
            return AUDIO;
        }
        if (type.equals(HTML.getCode())) {
            return HTML;
        }
        if (type.equals(THREAD_REQUEST.getCode())) {
            return THREAD_REQUEST;
        }
        if (type.equals(THREAD_LEAVE.getCode())) {
            return THREAD_LEAVE;
        }
        if (type.equals(THREAD_JOIN.getCode())) {
            return THREAD_JOIN;
        }
        if (type.equals(THREAD_REJECT.getCode())) {
            return THREAD_REJECT;
        }
        if (type.equals(LINK.getCode())) {
            return LINK;
        }
        if (type.equals(THREAD_PUBLISH.getCode())) {
            return THREAD_PUBLISH;
        }
        if (type.equals(CALL.getCode())) {
            return CALL;
        }
        if (type.equals(VIDEO_CALL.getCode())) {
            return VIDEO_CALL;
        }
        if (type.equals(LOCATION.getCode())) {
            return LOCATION;
        }
        if (type.equals(CONTACT.getCode())) {
            return CONTACT;
        }
        throw new IllegalArgumentException("Could not recognize type");
    }

    @TypeConverter
    public static Integer toInteger(@NonNull NoteType type) {
        Preconditions.checkNotNull((Object)((Object)type));
        return type.getCode();
    }

    @NonNull
    public Integer getCode() {
        return this.code;
    }
}

