/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.User;
import threads.core.api.UserStatus;
import threads.core.api.UserType;
import threads.iota.Entity;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class UserDecoder {
    private static final String TAG = UserDecoder.class.getSimpleName();

    @Nullable
    public static User convert(@NonNull Entity entity, @NonNull String aesKey) {
        try {
            Preconditions.checkNotNull((Object)entity);
            Preconditions.checkNotNull((Object)aesKey);
            Gson gson = new Gson();
            String data = Encryption.decrypt((String)entity.getContent(), (String)aesKey);
            Content content = (Content)gson.fromJson(data, Content.class);
            String publicKey = (String)content.get("pubKey");
            Preconditions.checkNotNull((Object)publicKey);
            String displayName = (String)content.get("alias");
            Preconditions.checkNotNull((Object)displayName);
            Preconditions.checkArgument((!displayName.isEmpty() ? 1 : 0) != 0);
            String pid = (String)content.get("pid");
            Preconditions.checkNotNull((Object)pid);
            String additions = (String)content.get("adds");
            User user = User.createUser(UserType.UNKNOWN, UserStatus.ONLINE, displayName, publicKey, PID.create((String)pid), null);
            if (additions != null && !additions.isEmpty()) {
                user.setExternalAdditions(Additionals.toHashMap(additions));
            }
            user.setHash(entity.getHash());
            user.setTimestamp(entity.getTimestamp());
            return user;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

