/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import threads.core.GatewayService;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Additional;
import threads.core.api.Additionals;
import threads.core.api.Peer;
import threads.core.api.PeerInfo;
import threads.core.api.User;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class IdentityService {
    public static boolean publishIdentity(@NonNull Context context, @NonNull String aesKey, @NonNull Map<String, String> params, boolean addIdentity, int timeout, int numPeers, boolean protectPeers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull(params);
        Preconditions.checkArgument((numPeers >= 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return false;
        }
        THREADS threads = Singleton.getInstance(context).getThreads();
        try {
            PID host = Preferences.getPID(context);
            if (host != null) {
                PeerInfo peer;
                IPFS ipfs;
                threads.ipfs.api.PeerInfo info = null;
                if (addIdentity && (ipfs = Singleton.getInstance(context).getIpfs()) != null) {
                    info = ipfs.id();
                }
                if ((peer = threads.getPeerInfoByPID(host)) != null) {
                    return IdentityService.updatePeerInfo(context, peer, info, aesKey, params, timeout, numPeers, protectPeers);
                }
                return IdentityService.createPeerInfo(context, info, host, aesKey, params, timeout, numPeers, protectPeers);
            }
        }
        catch (Throwable e) {
            Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
        }
        return false;
    }

    private static List<String> getMultiAddresses(@NonNull threads.ipfs.api.PeerInfo info) {
        Preconditions.checkNotNull((Object)info);
        ArrayList<String> addresses = new ArrayList<String>();
        for (String address : info.getMultiAddresses()) {
            if (address.startsWith("/ip6/::1/") || address.startsWith("/ip4/127.0.0.1/")) continue;
            addresses.add(address);
        }
        return addresses;
    }

    private static boolean createPeerInfo(@NonNull Context context, @Nullable threads.ipfs.api.PeerInfo info, @NonNull PID user, @NonNull String aesKey, @NonNull Map<String, String> params, int timeout, int numPeers, boolean protectRelays) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        PeerInfo peerInfo = threads.createPeerInfo(user);
        List<Peer> relayPeers = GatewayService.getRelayPeers(context, numPeers, timeout, protectRelays);
        for (Peer peer : relayPeers) {
            peerInfo.addAddress(peer.getPid(), peer.getMultiAddress());
        }
        for (Map.Entry entry : params.entrySet()) {
            peerInfo.addAdditional((String)entry.getKey(), (String)entry.getValue(), false);
        }
        if (info != null) {
            List<String> multiAddresses = IdentityService.getMultiAddresses(info);
            for (String address : multiAddresses) {
                peerInfo.addMultiAddresses(address);
            }
        }
        threads.storePeerInfo(peerInfo);
        return IdentityService.insertPeer(context, peerInfo, aesKey);
    }

    private static boolean insertPeer(@NonNull Context context, @NonNull PeerInfo peer, @NonNull String aesKey) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        Preconditions.checkNotNull((Object)iota);
        threads.setHash(peer, null);
        long start = System.currentTimeMillis();
        boolean success = threads.insertPeerInfo(iota, peer, aesKey);
        long time = (System.currentTimeMillis() - start) / 1000L;
        if (success) {
            Singleton.getInstance(context).getConsoleListener().info("Success store peer discovery information: " + time + " [s]");
        } else {
            Singleton.getInstance(context).getConsoleListener().error("Failed store peer discovery information: " + time + " [s]");
        }
        return success;
    }

    public static PeerInfo getPeerInfo(@NonNull Context context, @NonNull PID pid, @NonNull String aesKey, boolean updateUser) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        PeerInfo peerInfo = threads.getPeer(iota, pid, aesKey);
        if (peerInfo != null && updateUser) {
            boolean update = false;
            User user = threads.getUserByPID(pid);
            if (user != null) {
                Additionals additionals = peerInfo.getAdditionals();
                for (String key : additionals.keySet()) {
                    Additional additional = (Additional)additionals.get(key);
                    String value = additional.getValue();
                    user.addAdditional(key, value, true);
                    update = true;
                }
            }
            if (update) {
                threads.updateUser(user);
            }
        }
        return peerInfo;
    }

    private static boolean updatePeerInfo(@NonNull Context context, @NonNull PeerInfo peerInfo, @Nullable threads.ipfs.api.PeerInfo info, @NonNull String aesKey, @NonNull Map<String, String> params, int timeout, int numPeers, boolean protectPeers) {
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        THREADS threads = Singleton.getInstance(context).getThreads();
        peerInfo.removeAddresses();
        List<Peer> peers = GatewayService.getRelayPeers(context, numPeers, timeout, protectPeers);
        for (Peer peer : peers) {
            peerInfo.addAddress(peer.getPid(), peer.getMultiAddress());
        }
        peerInfo.removeAdditionals();
        for (Map.Entry entry : params.entrySet()) {
            peerInfo.addAdditional((String)entry.getKey(), (String)entry.getValue(), false);
        }
        peerInfo.removeMultiAddresses();
        if (info != null) {
            List<String> multiAddresses = IdentityService.getMultiAddresses(info);
            for (String address : multiAddresses) {
                peerInfo.addMultiAddresses(address);
            }
        }
        threads.updatePeerInfo(peerInfo);
        return IdentityService.insertPeer(context, peerInfo, aesKey);
    }
}

