/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import threads.core.GatewayService;
import threads.core.IdentityService;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Addresses;
import threads.core.api.Members;
import threads.core.api.MultiAddresses;
import threads.core.api.Note;
import threads.core.api.PeerInfo;
import threads.core.api.Thread;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class ConnectService {
    private static final String TAG = ConnectService.class.getSimpleName();

    public static boolean connectPeer(@NonNull Context context, @NonNull PID peer, @NonNull String aesKey, boolean supportDiscovery, boolean protectRelay, boolean protectPeer, boolean updateUser) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)peer);
        int timeout = Preferences.getConnectionTimeout(context);
        return ConnectService.connectPeer(context, peer, aesKey, timeout, supportDiscovery, protectRelay, protectPeer, updateUser);
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PID pid, @NonNull String aesKey, int timeout, boolean supportDiscovery, boolean protectRelay, boolean protectPeer, boolean updateUser) {
        PeerInfo peer;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return false;
        }
        if (supportDiscovery && (peer = IdentityService.getPeerInfo(context, pid, aesKey, updateUser)) != null && ConnectService.swarmConnect(context, peer, timeout, protectRelay, protectPeer)) {
            return true;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            boolean connected = ipfs.swarmConnect(pid, timeout);
            if (connected && protectPeer) {
                ipfs.protectPeer(pid, GatewayService.TAG);
            }
            return ipfs.isConnected(pid);
        }
        return false;
    }

    public static void swarmDisconnect(@NonNull Context context, @NonNull PeerInfo peer, boolean unprotectPeer) {
        Preconditions.checkNotNull((Object)peer);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            Addresses addresses = peer.getAddresses();
            for (String relay : addresses.keySet()) {
                PID pid = PID.create((String)relay);
                if (unprotectPeer) {
                    ipfs.unProtectPeer(pid, GatewayService.TAG);
                }
                ipfs.swarmDisconnect(pid);
            }
        }
    }

    public static boolean swarmConnect(@NonNull Context context, @NonNull PeerInfo peer, int timeout, boolean protectRelay, boolean protectPeer) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        Singleton.ConsoleListener consoleListener = Singleton.getInstance(context).getConsoleListener();
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            Addresses addresses = peer.getAddresses();
            for (String relay : addresses.keySet()) {
                try {
                    String address;
                    boolean connect;
                    String ma = (String)addresses.get(relay);
                    Preconditions.checkNotNull((Object)ma);
                    PID relayPID = PID.create((String)relay);
                    boolean relayConnected = ipfs.isConnected(relayPID);
                    if (!relayConnected) {
                        relayConnected = ipfs.swarmConnect(ma + "/" + IPFS.Style.p2p.name() + "/" + relay, timeout);
                    }
                    if (protectRelay && relayConnected) {
                        GatewayService.storePeer(context, PID.create((String)relay), ma, true, false, false, 0);
                        ipfs.protectPeer(PID.create((String)relay), GatewayService.TAG);
                    }
                    if (!relayConnected || !(connect = ipfs.swarmConnect(address = ipfs.relay_address(ma, relayPID, peer.getPID()), timeout)) || !protectPeer) continue;
                    ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            MultiAddresses multiAddresses = peer.getMultiAddresses();
            for (String address : multiAddresses) {
                try {
                    String ma = address.concat("/" + IPFS.Style.p2p + "/" + peer.getPID().getPid());
                    consoleListener.debug("Try connect : " + ma);
                    if (ipfs.isConnected(peer.getPID())) {
                        if (!protectPeer) break;
                        ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                        break;
                    }
                    boolean connect = ipfs.swarmConnect(ma, timeout);
                    if (!connect) continue;
                    if (protectPeer) {
                        ipfs.protectPeer(peer.getPID(), GatewayService.TAG);
                    }
                    consoleListener.info("Success connect : " + ma);
                    break;
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            return ipfs.isConnected(peer.getPID());
        }
        return false;
    }

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return ConnectService.connectPeer(context, pid, aesKey, timeout, supportDiscovery, protectRelay, protectPeer, updateUser);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static boolean publishNote(@NonNull Context context, @NonNull Note note, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Thread thread = threads.getThread(note);
        Preconditions.checkNotNull((Object)thread);
        boolean notifyAll = true;
        Members members = thread.getMembers();
        for (PID pid : members) {
            try {
                boolean result = ipfs.isConnected(pid);
                if (result) {
                    result = threads.publishNote(ipfs, pid, note);
                }
                if (result) continue;
                notifyAll = false;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        return notifyAll;
    }

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return ConnectService.connectPeer(context, pid, aesKey, supportDiscovery, protectRelay, protectPeer, updateUser);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)thread);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey, supportDiscovery, protectPeer, protectRelay, updateUser);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser, int timeout, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey, supportDiscovery, protectPeer, protectRelay, updateUser, timeout);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }
}

