/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.MultiAddresses;
import threads.core.api.PeerInfo;
import threads.core.api.PeerInfoDao;

public final class PeerInfoDao_Impl
implements PeerInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPeerInfo;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPeerInfo;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPeerInfo;
    private final SharedSQLiteStatement __preparedStmtOfClear;
    private final SharedSQLiteStatement __preparedStmtOfSetBundle;
    private final SharedSQLiteStatement __preparedStmtOfSetHash;

    public PeerInfoDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPeerInfo = new EntityInsertionAdapter<PeerInfo>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `PeerInfo`(`pid`,`addresses`,`multiAddresses`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PeerInfo value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                String _tmp = Addresses.toString(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = MultiAddresses.toString(value.getMultiAddresses());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = Additionals.toString(value.getAdditionals());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getBundle());
                }
                stmt.bindLong(7, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfPeerInfo = new EntityDeletionOrUpdateAdapter<PeerInfo>(__db){

            public String createQuery() {
                return "DELETE FROM `PeerInfo` WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PeerInfo value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
            }
        };
        this.__updateAdapterOfPeerInfo = new EntityDeletionOrUpdateAdapter<PeerInfo>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `PeerInfo` SET `pid` = ?,`addresses` = ?,`multiAddresses` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PeerInfo value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                String _tmp = Addresses.toString(value.getAddresses());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                String _tmp_1 = MultiAddresses.toString(value.getMultiAddresses());
                if (_tmp_1 == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp_1);
                }
                String _tmp_2 = Additionals.toString(value.getAdditionals());
                if (_tmp_2 == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp_2);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getBundle());
                }
                stmt.bindLong(7, value.getTimestamp());
                if (value.getPid() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getPid());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM PeerInfo";
                return "DELETE FROM PeerInfo";
            }
        };
        this.__preparedStmtOfSetBundle = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE PeerInfo SET bundle = ? WHERE pid = ?";
                return "UPDATE PeerInfo SET bundle = ? WHERE pid = ?";
            }
        };
        this.__preparedStmtOfSetHash = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "UPDATE PeerInfo SET hash = ? WHERE pid = ?";
                return "UPDATE PeerInfo SET hash = ? WHERE pid = ?";
            }
        };
    }

    @Override
    public void insertPeerInfo(PeerInfo peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPeerInfo.insert((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deletePeerInfo(PeerInfo peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPeerInfo.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updatePeerInfo(PeerInfo peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPeerInfo.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBundle(String pid, String bundle) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetBundle.acquire();
        int _argIndex = 1;
        if (bundle == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, bundle);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetBundle.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHash(String pid, String hash) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfSetHash.acquire();
        int _argIndex = 1;
        if (hash == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, hash);
        }
        _argIndex = 2;
        if (pid == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, pid);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfSetHash.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeerInfo getPeerInfoByPid(String pid) {
        String _sql = "SELECT * FROM PeerInfo WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PeerInfo WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            PeerInfo _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfAddresses = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addresses");
            int _cursorIndexOfMultiAddresses = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddresses");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                _result = new PeerInfo(_tmpPid);
                String _tmp = _cursor.getString(_cursorIndexOfAddresses);
                Addresses _tmpAddresses = Addresses.toAddresses(_tmp);
                _result.setAddresses(_tmpAddresses);
                String _tmp_1 = _cursor.getString(_cursorIndexOfMultiAddresses);
                MultiAddresses _tmpMultiAddresses = MultiAddresses.toMultiAddresses(_tmp_1);
                _result.setMultiAddresses(_tmpMultiAddresses);
                String _tmp_2 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_2);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            PeerInfo peerInfo = _result;
            return peerInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeerInfo getPeerInfoByHash(String hash) {
        String _sql = "SELECT * FROM PeerInfo WHERE hash =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM PeerInfo WHERE hash =?", (int)1);
        int _argIndex = 1;
        if (hash == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, hash);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            PeerInfo _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfAddresses = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"addresses");
            int _cursorIndexOfMultiAddresses = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddresses");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                _result = new PeerInfo(_tmpPid);
                String _tmp = _cursor.getString(_cursorIndexOfAddresses);
                Addresses _tmpAddresses = Addresses.toAddresses(_tmp);
                _result.setAddresses(_tmpAddresses);
                String _tmp_1 = _cursor.getString(_cursorIndexOfMultiAddresses);
                MultiAddresses _tmpMultiAddresses = MultiAddresses.toMultiAddresses(_tmp_1);
                _result.setMultiAddresses(_tmpMultiAddresses);
                String _tmp_2 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_2);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            PeerInfo peerInfo = _result;
            return peerInfo;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPeerInfoHash(String pid) {
        String _sql = "SELECT hash FROM PeerInfo WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT hash FROM PeerInfo WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            String _result = _cursor.moveToFirst() ? _cursor.getString(0) : null;
            String string = _result;
            return string;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

