/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum NoteStatus {
    OFFLINE(0),
    SENDING(1),
    PUBLISHING(2),
    ONLINE(3),
    SEEDING(4),
    DELETING(5),
    EXPIRED(6),
    LEACHING(7),
    ERROR(8);

    @NonNull
    private final Integer code;

    private NoteStatus(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static NoteStatus toStatus(Integer status) {
        Preconditions.checkNotNull((Object)status);
        if (status.equals(SEEDING.getCode())) {
            return SEEDING;
        }
        if (status.equals(SENDING.getCode())) {
            return SENDING;
        }
        if (status.equals(PUBLISHING.getCode())) {
            return PUBLISHING;
        }
        if (status.equals(ONLINE.getCode())) {
            return ONLINE;
        }
        if (status.equals(OFFLINE.getCode())) {
            return OFFLINE;
        }
        if (status.equals(DELETING.getCode())) {
            return DELETING;
        }
        if (status.equals(EXPIRED.getCode())) {
            return EXPIRED;
        }
        if (status.equals(LEACHING.getCode())) {
            return LEACHING;
        }
        if (status.equals(ERROR.getCode())) {
            return ERROR;
        }
        throw new IllegalArgumentException("Could not recognize status");
    }

    @TypeConverter
    public static Integer toInteger(NoteStatus status) {
        Preconditions.checkNotNull((Object)((Object)status));
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return this.code;
    }
}

