/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.Entity;
import androidx.room.PrimaryKey;
import androidx.room.TypeConverter;
import androidx.room.TypeConverters;
import java.util.Date;

@Entity
public class Event {
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="identifier")
    private final String identifier;
    @NonNull
    @ColumnInfo(name="content")
    private final String content;
    @NonNull
    @TypeConverters(value={Event.class})
    @ColumnInfo(name="date")
    private final Date date;

    Event(@NonNull String identifier, @NonNull String content, @NonNull Date date) {
        Preconditions.checkNotNull((Object)identifier);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)date);
        this.identifier = identifier;
        this.date = date;
        this.content = content;
    }

    public static Event createEvent(@NonNull String identifier, @NonNull String content) {
        return new Event(identifier, content, new Date());
    }

    @TypeConverter
    public static Date toDate(Long value) {
        return value == null ? null : new Date(value);
    }

    @TypeConverter
    public static Long toLong(Date date) {
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    @NonNull
    public String getContent() {
        return this.content;
    }

    @NonNull
    public Date getDate() {
        return this.date;
    }

    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }
}

