package threads.core.api;


import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import java.util.List;

@Dao
public interface PeerDao {
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertPeer(Peer peer);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    void updatePeer(Peer peer);

    @Delete
    void deletePeer(Peer peer);

    @Query("DELETE FROM Peer")
    void clear();

    @Query("SELECT * FROM Peer WHERE pid = :pid")
    Peer getPeerByPid(String pid);

    @Query("SELECT * FROM Peer WHERE isRelay = 1")
    List<Peer> getRelayPeers();

    @Query("SELECT * FROM Peer WHERE isAutonat = 1")
    List<Peer> getAutonatPeers();

    @Query("SELECT * FROM Peer WHERE isPubsub = 1")
    List<Peer> getPubsubPeers();
}
