/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import threads.core.IdentityService;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Members;
import threads.core.api.Note;
import threads.core.api.Thread;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class ConnectService {
    private static final String TAG = ConnectService.class.getSimpleName();

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return IdentityService.connectPeer(context, pid, aesKey, timeout, supportDiscovery, protectRelay, protectPeer, updateUser);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static boolean publishNote(@NonNull Context context, @NonNull Note note, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Thread thread = threads.getThread(note);
        Preconditions.checkNotNull((Object)thread);
        boolean notifyAll = true;
        Members members = thread.getMembers();
        for (PID pid : members) {
            try {
                boolean result = ipfs.isConnected(pid);
                if (result) {
                    result = threads.publishNote(ipfs, pid, note);
                }
                if (result) continue;
                notifyAll = false;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        return notifyAll;
    }

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return IdentityService.connectPeer(context, pid, aesKey, supportDiscovery, protectRelay, protectPeer, updateUser);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)thread);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey, supportDiscovery, protectPeer, protectRelay, updateUser);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean supportDiscovery, boolean protectPeer, boolean protectRelay, boolean updateUser, int timeout, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkArgument((timeout > 0 ? 1 : 0) != 0);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey, supportDiscovery, protectPeer, protectRelay, updateUser, timeout);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }
}

