/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.Query;
import androidx.room.TypeConverters;
import androidx.room.Update;
import java.util.List;
import threads.core.api.Converter;
import threads.core.api.User;
import threads.core.api.UserStatus;
import threads.core.api.UserType;
import threads.ipfs.api.CID;

@Dao
public interface UserDao {
    @Insert(onConflict=1)
    public void insertUsers(User ... var1);

    @Update(onConflict=1)
    public void updateUser(User var1);

    @Query(value="DELETE FROM User")
    public void clear();

    @Query(value="SELECT * FROM User WHERE status LIKE :status")
    @TypeConverters(value={UserStatus.class})
    public List<User> getUsersByStatus(UserStatus var1);

    @Query(value="SELECT * FROM User")
    public List<User> getUsers();

    @Query(value="SELECT pid FROM User")
    public List<String> getUserPids();

    @Query(value="UPDATE User SET hash = :hash WHERE pid = :pid")
    public void setHash(String var1, String var2);

    @Query(value="UPDATE User SET alias = :alias WHERE pid = :pid")
    public void setAlias(String var1, String var2);

    @Query(value="UPDATE User SET publicKey = :publicKey WHERE pid = :pid")
    public void setPublicKey(String var1, String var2);

    @Query(value="UPDATE User SET image = :image WHERE pid = :pid")
    @TypeConverters(value={Converter.class})
    public void setImage(String var1, CID var2);

    @Query(value="SELECT publicKey FROM User WHERE pid = :pid ")
    public String getPublicKey(String var1);

    @Query(value="SELECT alias FROM User WHERE pid = :pid ")
    public String getAlias(String var1);

    @Query(value="SELECT * FROM User WHERE pid = :pid")
    public User getUserByPid(String var1);

    @Query(value="SELECT * FROM User WHERE pid IN (:pids)")
    public List<User> getUsersByPid(String ... var1);

    @Query(value="SELECT * FROM User WHERE pid = :pid")
    public LiveData<User> getLiveDataUser(String var1);

    @Query(value="DELETE FROM User WHERE pid = :pid")
    public void removeUserByPid(String var1);

    @Query(value="DELETE FROM User WHERE pid IN (:pids)")
    public void removeUsersByPid(String ... var1);

    @Query(value="SELECT * FROM User")
    public LiveData<List<User>> getLiveDataUsers();

    @Query(value="SELECT * FROM User WHERE type = :type")
    @TypeConverters(value={UserType.class})
    public LiveData<List<User>> getLiveDataUsersByType(UserType var1);

    @Query(value="UPDATE User SET type = :type WHERE pid = :pid")
    @TypeConverters(value={UserType.class})
    public void setUserType(String var1, UserType var2);

    @Query(value="UPDATE User SET status = :status WHERE pid = :pid")
    @TypeConverters(value={UserStatus.class})
    public void setUserStatus(String var1, UserStatus var2);

    @Query(value="UPDATE User SET status = :newStatus WHERE status = :oldStatus")
    @TypeConverters(value={UserStatus.class})
    public void setUserStatus(UserStatus var1, UserStatus var2);

    @Query(value="SELECT * FROM User WHERE hash =:hash")
    public User getUserByHash(String var1);

    @Query(value="UPDATE User SET bundle = :bundle WHERE pid = :pid")
    public void setBundle(String var1, String var2);

    @Delete
    public void removeUsers(User ... var1);

    @Query(value="SELECT COUNT(*) FROM User WHERE pid = :pid")
    public long hasUser(String var1);

    @Query(value="SELECT status FROM User WHERE pid = :pid")
    @TypeConverters(value={UserStatus.class})
    public UserStatus getUserStatus(String var1);

    @Query(value="UPDATE User SET status = :status WHERE pid IN (:pids)")
    @TypeConverters(value={UserStatus.class})
    public void setUsersStatus(UserStatus var1, String ... var2);

    @Query(value="UPDATE User SET blocked = :blocked WHERE pid = :pid")
    public void setBlocked(String var1, boolean var2);

    @Query(value="SELECT blocked FROM User WHERE pid = :pid ")
    public boolean isBlocked(String var1);
}

