/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.concurrent.Callable;
import threads.core.api.Additionals;
import threads.core.api.Settings;
import threads.core.api.SettingsDao;

public final class SettingsDao_Impl
implements SettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfSettings;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfSettings;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public SettingsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfSettings = new EntityInsertionAdapter<Settings>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Settings`(`id`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Settings value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                String _tmp = Additionals.toString(value.getAdditionals());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getBundle());
                }
                stmt.bindLong(5, value.getTimestamp());
            }
        };
        this.__updateAdapterOfSettings = new EntityDeletionOrUpdateAdapter<Settings>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Settings` SET `id` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `id` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Settings value) {
                if (value.getId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getId());
                }
                String _tmp = Additionals.toString(value.getAdditionals());
                if (_tmp == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, _tmp);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getBundle());
                }
                stmt.bindLong(5, value.getTimestamp());
                if (value.getId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getId());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Settings";
                return "DELETE FROM Settings";
            }
        };
    }

    @Override
    public void insertSettings(Settings ... settings) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfSettings.insert((Object[])settings);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateSettings(Settings settings) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfSettings.handle((Object)settings);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Settings getSettings(String id) {
        String _sql = "SELECT * FROM Settings WHERE id =?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Settings WHERE id =?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Settings _result;
            int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpId = _cursor.getString(_cursorIndexOfId);
                _result = new Settings(_tmpId);
                String _tmp = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Settings settings = _result;
            return settings;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<Settings> getLiveDataSettings(String id) {
        String _sql = "SELECT * FROM Settings WHERE id =?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Settings WHERE id =?", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Settings"}, false, (Callable)new Callable<Settings>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Settings call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)SettingsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    Settings _result;
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
                    int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
                    int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    if (_cursor.moveToFirst()) {
                        String _tmpId = _cursor.getString(_cursorIndexOfId);
                        _result = new Settings(_tmpId);
                        String _tmp = _cursor.getString(_cursorIndexOfAdditionals);
                        Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp);
                        _result.setAdditionals(_tmpAdditionals);
                        String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                        _result.setHash(_tmpHash);
                        String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                        _result.setBundle(_tmpBundle);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _result.setTimestamp(_tmpTimestamp);
                    } else {
                        _result = null;
                    }
                    Settings settings = _result;
                    return settings;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

