/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import threads.core.api.Message;
import threads.core.api.MessageDao;
import threads.core.api.MessageKind;

public final class MessageDao_Impl
implements MessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfMessage;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfMessage;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public MessageDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMessage = new EntityInsertionAdapter<Message>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Message`(`message`,`timestamp`,`messageKind`,`idx`) VALUES (?,?,?,nullif(?, 0))";
            }

            public void bind(SupportSQLiteStatement stmt, Message value) {
                if (value.getMessage() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getMessage());
                }
                stmt.bindLong(2, value.getTimestamp());
                Integer _tmp = MessageKind.toInteger(value.getMessageKind());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, (long)_tmp.intValue());
                }
                stmt.bindLong(4, value.getIdx());
            }
        };
        this.__deletionAdapterOfMessage = new EntityDeletionOrUpdateAdapter<Message>(__db){

            public String createQuery() {
                return "DELETE FROM `Message` WHERE `idx` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Message value) {
                stmt.bindLong(1, value.getIdx());
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Message";
                return "DELETE FROM Message";
            }
        };
    }

    @Override
    public void insertMessages(Message ... messages) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfMessage.insert((Object[])messages);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteMessage(Message message) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMessage.handle((Object)message);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message[] getMessages() {
        String _sql = "SELECT * FROM Message";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Message", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            int _cursorIndexOfMessageKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageKind");
            int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
            Message[] _result = new Message[_cursor.getCount()];
            int _index = 0;
            while (_cursor.moveToNext()) {
                String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                Integer _tmp = _cursor.isNull(_cursorIndexOfMessageKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMessageKind));
                MessageKind _tmpMessageKind = MessageKind.toMessageKind(_tmp);
                Message _item = new Message(_tmpMessageKind, _tmpMessage, _tmpTimestamp);
                long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                _item.setIdx(_tmpIdx);
                _result[_index] = _item;
                ++_index;
            }
            Message[] messageArray = _result;
            return messageArray;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @Override
    public LiveData<List<Message>> getLiveDataMessages() {
        String _sql = "SELECT * FROM Message";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Message", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Message"}, false, (Callable)new Callable<List<Message>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<Message> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)MessageDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    int _cursorIndexOfMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"message");
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfMessageKind = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageKind");
                    int _cursorIndexOfIdx = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"idx");
                    ArrayList<Message> _result = new ArrayList<Message>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        String _tmpMessage = _cursor.getString(_cursorIndexOfMessage);
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        Integer _tmp = _cursor.isNull(_cursorIndexOfMessageKind) ? null : Integer.valueOf(_cursor.getInt(_cursorIndexOfMessageKind));
                        MessageKind _tmpMessageKind = MessageKind.toMessageKind(_tmp);
                        Message _item = new Message(_tmpMessageKind, _tmpMessage, _tmpTimestamp);
                        long _tmpIdx = _cursor.getLong(_cursorIndexOfIdx);
                        _item.setIdx(_tmpIdx);
                        _result.add(_item);
                    }
                    ArrayList<Message> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

