/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.HashMap;
import java.util.HashSet;
import threads.core.api.PeerDao;
import threads.core.api.PeerDao_Impl;
import threads.core.api.PeersDatabase;

public final class PeersDatabase_Impl
extends PeersDatabase {
    private volatile PeerDao _peerDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(4){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Peer` (`pid` TEXT NOT NULL, `multiAddress` TEXT NOT NULL, `isRelay` INTEGER NOT NULL, `isAutonat` INTEGER NOT NULL, `isPubsub` INTEGER NOT NULL, `rating` INTEGER NOT NULL, `additionals` TEXT NOT NULL, `hash` TEXT, `bundle` TEXT, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`pid`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'cd725b1d5706d3a82a8bc01c09661e06')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `Peer`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (PeersDatabase_Impl.this.mCallbacks != null) {
                    int _size = PeersDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)PeersDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                PeersDatabase_Impl.this.mDatabase = _db;
                PeersDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (PeersDatabase_Impl.this.mCallbacks != null) {
                    int _size = PeersDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)PeersDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsPeer = new HashMap<String, TableInfo.Column>(10);
                _columnsPeer.put("pid", new TableInfo.Column("pid", "TEXT", true, 1));
                _columnsPeer.put("multiAddress", new TableInfo.Column("multiAddress", "TEXT", true, 0));
                _columnsPeer.put("isRelay", new TableInfo.Column("isRelay", "INTEGER", true, 0));
                _columnsPeer.put("isAutonat", new TableInfo.Column("isAutonat", "INTEGER", true, 0));
                _columnsPeer.put("isPubsub", new TableInfo.Column("isPubsub", "INTEGER", true, 0));
                _columnsPeer.put("rating", new TableInfo.Column("rating", "INTEGER", true, 0));
                _columnsPeer.put("additionals", new TableInfo.Column("additionals", "TEXT", true, 0));
                _columnsPeer.put("hash", new TableInfo.Column("hash", "TEXT", false, 0));
                _columnsPeer.put("bundle", new TableInfo.Column("bundle", "TEXT", false, 0));
                _columnsPeer.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                HashSet _foreignKeysPeer = new HashSet(0);
                HashSet _indicesPeer = new HashSet(0);
                TableInfo _infoPeer = new TableInfo("Peer", _columnsPeer, _foreignKeysPeer, _indicesPeer);
                TableInfo _existingPeer = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Peer");
                if (!_infoPeer.equals((Object)_existingPeer)) {
                    throw new IllegalStateException("Migration didn't properly handle Peer(threads.core.api.Peer).\n Expected:\n" + _infoPeer + "\n Found:\n" + _existingPeer);
                }
            }
        }, "cd725b1d5706d3a82a8bc01c09661e06", "aae79ff5321ab658d9aad37cd14cabb7");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"Peer"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `Peer`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PeerDao peersDao() {
        if (this._peerDao != null) {
            return this._peerDao;
        }
        PeersDatabase_Impl peersDatabase_Impl = this;
        synchronized (peersDatabase_Impl) {
            if (this._peerDao == null) {
                this._peerDao = new PeerDao_Impl(this);
            }
            return this._peerDao;
        }
    }
}

