/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.google.gson.Gson;
import threads.core.api.Additionals;
import threads.core.api.Addresses;
import threads.core.api.Content;
import threads.core.api.MultiAddresses;
import threads.core.api.PeerInfo;
import threads.iota.Entity;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

public class PeerInfoDecoder {
    private static final String TAG = PeerInfoDecoder.class.getSimpleName();

    @Nullable
    public static PeerInfo convert(@NonNull PID owner, @NonNull Entity entity, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)entity);
        Preconditions.checkNotNull((Object)aesKey);
        Gson gson = new Gson();
        try {
            Content content = (Content)gson.fromJson(entity.getContent(), Content.class);
            PeerInfo peer = PeerInfoDecoder.convert(owner, content, aesKey);
            if (peer != null) {
                peer.setHash(entity.getHash());
                peer.setBundle(entity.getBundle());
                peer.setTimestamp(entity.getTimestamp());
            }
            return peer;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static PeerInfo convert(@NonNull PID owner, @NonNull Content content, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)owner);
        Preconditions.checkNotNull((Object)content);
        Preconditions.checkNotNull((Object)aesKey);
        try {
            String mads;
            PeerInfo peer = PeerInfo.createPeerInfo(owner);
            String peers = (String)content.get("peers");
            if (peers != null) {
                Addresses addresses = Addresses.toAddresses(Encryption.decrypt((String)peers, (String)aesKey));
                Preconditions.checkNotNull((Object)addresses);
                peer.setAddresses(addresses);
            }
            if ((mads = (String)content.get("mads")) != null) {
                MultiAddresses multiAddresses = MultiAddresses.toMultiAddresses(Encryption.decrypt((String)mads, (String)aesKey));
                Preconditions.checkNotNull((Object)multiAddresses);
                peer.setMultiAddresses(multiAddresses);
            }
            String additions = (String)content.get("adds");
            Preconditions.checkNotNull((Object)additions);
            if (!additions.isEmpty()) {
                peer.setExternalAdditions(Additionals.toHashMap(Encryption.decrypt((String)additions, (String)aesKey)));
            }
            return peer;
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            return null;
        }
    }
}

