/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.HashMap;
import threads.core.api.Additionals;
import threads.core.api.Content;
import threads.core.api.Note;
import threads.ipfs.api.CID;
import threads.ipfs.api.Encryption;

public class NoteRequestEncoder {
    @NonNull
    public static Content convert(@NonNull String publicKey, @NonNull Note note) throws Exception {
        Preconditions.checkNotNull((Object)publicKey);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkArgument((!publicKey.isEmpty() ? 1 : 0) != 0);
        Content content = new Content();
        String sesKey = note.getSesKey();
        content.put("pid", note.getSenderPid().getPid());
        content.put("pubKey", note.getSenderKey());
        content.put("date", String.valueOf(note.getDate().getTime()));
        content.put("alias", Encryption.encrypt((String)note.getSenderAlias(), (String)sesKey));
        if (!sesKey.isEmpty()) {
            content.put("sesKey", Encryption.encryptRSA((String)sesKey, (String)publicKey));
        }
        CID thread = note.getThread();
        Preconditions.checkNotNull((Object)thread);
        content.put("thread", Encryption.encrypt((String)thread.getCid(), (String)sesKey));
        HashMap<String, String> additions = note.getExternalAdditions();
        Preconditions.checkNotNull(additions);
        content.put("adds", Encryption.encrypt((String)Additionals.toString(additions), (String)sesKey));
        return content;
    }
}

