/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.Date;
import java.util.concurrent.Callable;
import threads.core.api.Event;
import threads.core.api.EventDao;

public final class EventDao_Impl
implements EventDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfEvent;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfEvent;
    private final SharedSQLiteStatement __preparedStmtOfDeleteEvent;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public EventDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfEvent = new EntityInsertionAdapter<Event>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Event`(`identifier`,`content`,`date`) VALUES (?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Event value) {
                if (value.getIdentifier() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getIdentifier());
                }
                if (value.getContent() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getContent());
                }
                Long _tmp = Event.toLong(value.getDate());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindLong(3, _tmp.longValue());
                }
            }
        };
        this.__deletionAdapterOfEvent = new EntityDeletionOrUpdateAdapter<Event>(__db){

            public String createQuery() {
                return "DELETE FROM `Event` WHERE `identifier` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Event value) {
                if (value.getIdentifier() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getIdentifier());
                }
            }
        };
        this.__preparedStmtOfDeleteEvent = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Event WHERE  identifier =?";
                return "DELETE FROM Event WHERE  identifier =?";
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Event";
                return "DELETE FROM Event";
            }
        };
    }

    @Override
    public void insertEvent(Event event) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfEvent.insert((Object)event);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteEvent(Event event) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfEvent.handle((Object)event);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteEvent(String identifier) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteEvent.acquire();
        int _argIndex = 1;
        if (identifier == null) {
            _stmt.bindNull(_argIndex);
        } else {
            _stmt.bindString(_argIndex, identifier);
        }
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteEvent.release(_stmt);
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    @Override
    public LiveData<Event> getEvent(String identifier) {
        String _sql = "SELECT * FROM Event WHERE  identifier  =?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Event WHERE  identifier  =?", (int)1);
        int _argIndex = 1;
        if (identifier == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, identifier);
        }
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"Event"}, false, (Callable)new Callable<Event>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Event call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)EventDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false);){
                    Event _result;
                    int _cursorIndexOfIdentifier = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"identifier");
                    int _cursorIndexOfContent = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"content");
                    int _cursorIndexOfDate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"date");
                    if (_cursor.moveToFirst()) {
                        String _tmpIdentifier = _cursor.getString(_cursorIndexOfIdentifier);
                        String _tmpContent = _cursor.getString(_cursorIndexOfContent);
                        Long _tmp = _cursor.isNull(_cursorIndexOfDate) ? null : Long.valueOf(_cursor.getLong(_cursorIndexOfDate));
                        Date _tmpDate = Event.toDate(_tmp);
                        _result = new Event(_tmpIdentifier, _tmpContent, _tmpDate);
                    } else {
                        _result = null;
                    }
                    Event event = _result;
                    return event;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }
}

