/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import androidx.room.Room;
import androidx.room.migration.Migration;
import androidx.sqlite.db.SupportSQLiteDatabase;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.THREADS;
import threads.core.api.EventsDatabase;
import threads.core.api.Message;
import threads.core.api.MessageKind;
import threads.core.api.PeersDatabase;
import threads.core.api.PeersInfoDatabase;
import threads.core.api.Server;
import threads.core.api.ThreadsDatabase;
import threads.iota.EntityService;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.AddressesConfig;
import threads.ipfs.api.ApiListener;
import threads.ipfs.api.ConnMgrConfig;
import threads.ipfs.api.DiscoveryConfig;
import threads.ipfs.api.ExperimentalConfig;
import threads.ipfs.api.PubsubConfig;
import threads.ipfs.api.ReproviderConfig;
import threads.ipfs.api.RoutingConfig;
import threads.ipfs.api.SwarmConfig;

public class Singleton {
    private static final Migration MIGRATION_61_62 = new Migration(61, 62){

        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("DROP TABLE TransactionHash");
        }
    };
    private static final Migration MIGRATION_62_63 = new Migration(62, 63){

        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("DROP TABLE BlockAccount");
            database.execSQL("ALTER TABLE User ADD COLUMN blocked INTEGER DEFAULT 0 NOT NULL");
        }
    };
    private static final Migration MIGRATION_63_64 = new Migration(63, 64){

        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("DROP TABLE Peer");
        }
    };
    private static final Migration MIGRATION_64_65 = new Migration(64, 65){

        public void migrate(SupportSQLiteDatabase database) {
            database.execSQL("ALTER TABLE Thread ADD COLUMN pinned INTEGER DEFAULT 0 NOT NULL");
        }
    };
    private static Singleton SINGLETON = null;
    private final IOTA iota;
    private final ThreadsDatabase threadsDatabase;
    private final EventsDatabase eventsDatabase;
    private final PeersInfoDatabase peersInfoDatabase;
    private final PeersDatabase peersDatabase;
    private final THREADS threads;
    private final ConsoleListener consoleListener = new ConsoleListener();
    @Nullable
    private IPFS ipfs = null;

    private Singleton(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        this.threadsDatabase = (ThreadsDatabase)Room.databaseBuilder((Context)context, ThreadsDatabase.class, (String)ThreadsDatabase.class.getSimpleName()).addMigrations(new Migration[]{MIGRATION_61_62, MIGRATION_62_63, MIGRATION_63_64, MIGRATION_64_65}).build();
        this.eventsDatabase = (EventsDatabase)Room.inMemoryDatabaseBuilder((Context)context, EventsDatabase.class).build();
        this.peersInfoDatabase = (PeersInfoDatabase)Room.inMemoryDatabaseBuilder((Context)context, PeersInfoDatabase.class).build();
        this.peersDatabase = (PeersDatabase)Room.databaseBuilder((Context)context, PeersDatabase.class, (String)PeersDatabase.class.getSimpleName()).fallbackToDestructiveMigration().build();
        EntityService entityService = EntityService.getInstance((Context)context);
        this.threads = THREADS.createThreads(this.threadsDatabase, this.eventsDatabase, this.peersInfoDatabase, this.peersDatabase, entityService);
        this.consoleListener.setReport(Preferences.isReportMode(context));
        this.consoleListener.setDebug(Preferences.isDebugMode(context));
        IOTA.Builder iotaBuilder = new IOTA.Builder();
        Server server = Preferences.getTangleServer(context);
        iotaBuilder.protocol(server.getProtocol());
        iotaBuilder.host(server.getHost());
        iotaBuilder.port(server.getPort());
        iotaBuilder.timeout(Preferences.getTangleTimeout(context));
        this.iota = iotaBuilder.build();
        int swarmPort = Preferences.getSwarmPort(context);
        if (Preferences.isRandomSwarmPort(context)) {
            swarmPort = Network.nextFreePort();
        }
        Integer quicPort = null;
        if (Preferences.isQUICEnabled(context)) {
            quicPort = swarmPort;
        }
        AddressesConfig addresses = AddressesConfig.create((Integer)swarmPort, (Integer)quicPort);
        ExperimentalConfig experimental = ExperimentalConfig.create();
        experimental.setQUIC(Preferences.isQUICEnabled(context));
        experimental.setFilestoreEnabled(Preferences.isFilestoreEnabled(context));
        experimental.setPreferTLS(Preferences.isPreferTLS(context));
        PubsubConfig pubsub = PubsubConfig.create();
        pubsub.setRouter(Preferences.getPubsubRouter(context));
        SwarmConfig swarmConfig = SwarmConfig.create();
        swarmConfig.setDisableBandwidthMetrics(true);
        swarmConfig.setDisableNatPortMap(false);
        swarmConfig.setDisableRelay(false);
        swarmConfig.setEnableAutoRelay(Preferences.isAutoRelayEnabled(context));
        swarmConfig.setEnableAutoNATService(Preferences.isAutoNATServiceEnabled(context));
        swarmConfig.setEnableRelayHop(Preferences.isRelayHopEnabled(context));
        ConnMgrConfig mgr = swarmConfig.getConnMgr();
        mgr.setGracePeriod(Preferences.getGracePeriod(context));
        mgr.setHighWater(Preferences.getHighWater(context));
        mgr.setLowWater(Preferences.getLowWater(context));
        mgr.setType(Preferences.getConnMgrConfigType(context));
        DiscoveryConfig discoveryConfig = DiscoveryConfig.create();
        discoveryConfig.getMdns().setEnabled(Preferences.isMdnsEnabled(context));
        ReproviderConfig reproviderConfig = ReproviderConfig.create();
        reproviderConfig.setInterval(Preferences.getReproviderInterval(context));
        RoutingConfig routingConfig = RoutingConfig.create();
        routingConfig.setType(Preferences.getRoutingType(context));
        try {
            this.ipfs = IPFS.getInstance((Context)context, (ApiListener)this.consoleListener, (AddressesConfig)addresses, (ExperimentalConfig)experimental, (PubsubConfig)pubsub, (DiscoveryConfig)discoveryConfig, (SwarmConfig)swarmConfig, (RoutingConfig)routingConfig, (ReproviderConfig)reproviderConfig);
            Preferences.setPID(context, this.ipfs.getPeerID());
        }
        catch (Throwable e) {
            Preferences.evaluateException(this.threads, "IPFS_INSTALL_FAILURE", e);
        }
    }

    @NonNull
    public static Singleton getInstance(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        if (SINGLETON == null) {
            SINGLETON = new Singleton(context);
        }
        return SINGLETON;
    }

    public PeersDatabase getPeersDatabase() {
        return this.peersDatabase;
    }

    @NonNull
    public PeersInfoDatabase getPeersInfoDatabase() {
        return this.peersInfoDatabase;
    }

    @NonNull
    public ConsoleListener getConsoleListener() {
        return this.consoleListener;
    }

    @NonNull
    public IOTA getIota() {
        return this.iota;
    }

    @Nullable
    public IPFS getIpfs() {
        return this.ipfs;
    }

    @NonNull
    public EventsDatabase getEventsDatabase() {
        return this.eventsDatabase;
    }

    @NonNull
    public THREADS getThreads() {
        return this.threads;
    }

    @NonNull
    public ThreadsDatabase getThreadsDatabase() {
        return this.threadsDatabase;
    }

    public class ConsoleListener
    implements ApiListener {
        private boolean debug = false;
        private boolean report = false;

        public boolean isDebug() {
            return this.debug;
        }

        public void setDebug(boolean debug) {
            this.debug = debug;
        }

        public boolean isReport() {
            return this.report;
        }

        public void setReport(boolean report) {
            this.report = report;
        }

        public void debug(@NonNull String message) {
            if (this.debug && this.report) {
                long timestamp = System.currentTimeMillis();
                new Thread(() -> {
                    Message em = Singleton.this.threads.createMessage(MessageKind.DEBUG, message, timestamp);
                    Singleton.this.threads.storeMessage(em);
                }).start();
            }
        }

        public void info(@NonNull String message) {
            if (this.report) {
                long timestamp = System.currentTimeMillis();
                new Thread(() -> {
                    Message em = Singleton.this.threads.createMessage(MessageKind.INFO, message, timestamp);
                    Singleton.this.threads.storeMessage(em);
                }).start();
            }
        }

        public void error(@NonNull String message) {
            if (this.report) {
                long timestamp = System.currentTimeMillis();
                new Thread(() -> {
                    Message em = Singleton.this.threads.createMessage(MessageKind.ERROR, message, timestamp);
                    Singleton.this.threads.storeMessage(em);
                }).start();
            }
        }
    }
}

