/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.List;
import threads.core.api.Additionals;
import threads.core.api.Peer;
import threads.core.api.PeerDao;

public final class PeerDao_Impl
implements PeerDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter __insertionAdapterOfPeer;
    private final EntityDeletionOrUpdateAdapter __deletionAdapterOfPeer;
    private final EntityDeletionOrUpdateAdapter __updateAdapterOfPeer;
    private final SharedSQLiteStatement __preparedStmtOfClear;

    public PeerDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPeer = new EntityInsertionAdapter<Peer>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `Peer`(`pid`,`multiAddress`,`isRelay`,`isAutonat`,`rating`,`additionals`,`hash`,`bundle`,`timestamp`) VALUES (?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getMultiAddress() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMultiAddress());
                }
                int _tmp = value.isRelay() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                int _tmp_1 = value.isAutonat() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_1);
                stmt.bindLong(5, (long)value.getRating());
                String _tmp_2 = Additionals.toString(value.getAdditionals());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getBundle());
                }
                stmt.bindLong(9, value.getTimestamp());
            }
        };
        this.__deletionAdapterOfPeer = new EntityDeletionOrUpdateAdapter<Peer>(__db){

            public String createQuery() {
                return "DELETE FROM `Peer` WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
            }
        };
        this.__updateAdapterOfPeer = new EntityDeletionOrUpdateAdapter<Peer>(__db){

            public String createQuery() {
                return "UPDATE OR REPLACE `Peer` SET `pid` = ?,`multiAddress` = ?,`isRelay` = ?,`isAutonat` = ?,`rating` = ?,`additionals` = ?,`hash` = ?,`bundle` = ?,`timestamp` = ? WHERE `pid` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, Peer value) {
                if (value.getPid() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPid());
                }
                if (value.getMultiAddress() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getMultiAddress());
                }
                int _tmp = value.isRelay() ? 1 : 0;
                stmt.bindLong(3, (long)_tmp);
                int _tmp_1 = value.isAutonat() ? 1 : 0;
                stmt.bindLong(4, (long)_tmp_1);
                stmt.bindLong(5, (long)value.getRating());
                String _tmp_2 = Additionals.toString(value.getAdditionals());
                if (_tmp_2 == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, _tmp_2);
                }
                if (value.getHash() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getHash());
                }
                if (value.getBundle() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getBundle());
                }
                stmt.bindLong(9, value.getTimestamp());
                if (value.getPid() == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, value.getPid());
                }
            }
        };
        this.__preparedStmtOfClear = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "DELETE FROM Peer";
                return "DELETE FROM Peer";
            }
        };
    }

    @Override
    public void insertPeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPeer.insert((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deletePeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPeer.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updatePeer(Peer peer) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPeer.handle((Object)peer);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void clear() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfClear.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfClear.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Peer getPeerByPid(String pid) {
        String _sql = "SELECT * FROM Peer WHERE pid = ?";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE pid = ?", (int)1);
        int _argIndex = 1;
        if (pid == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pid);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            Peer _result;
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            if (_cursor.moveToFirst()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                _result = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _result.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _result.setAutonat(_tmpIsAutonat);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _result.setRating(_tmpRating);
                String _tmp_2 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_2);
                _result.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _result.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _result.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _result.setTimestamp(_tmpTimestamp);
            } else {
                _result = null;
            }
            Peer peer = _result;
            return peer;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Peer> getRelayPeers() {
        String _sql = "SELECT * FROM Peer WHERE isRelay = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE isRelay = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Peer> _result = new ArrayList<Peer>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                Peer _item = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _item.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _item.setAutonat(_tmpIsAutonat);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _item.setRating(_tmpRating);
                String _tmp_2 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_2);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Peer> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Peer> getAutonatPeers() {
        String _sql = "SELECT * FROM Peer WHERE isAutonat = 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM Peer WHERE isAutonat = 1", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false);
        try {
            int _cursorIndexOfPid = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pid");
            int _cursorIndexOfMultiAddress = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"multiAddress");
            int _cursorIndexOfIsRelay = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isRelay");
            int _cursorIndexOfIsAutonat = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isAutonat");
            int _cursorIndexOfRating = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"rating");
            int _cursorIndexOfAdditionals = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"additionals");
            int _cursorIndexOfHash = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"hash");
            int _cursorIndexOfBundle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"bundle");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<Peer> _result = new ArrayList<Peer>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpPid = _cursor.getString(_cursorIndexOfPid);
                String _tmpMultiAddress = _cursor.getString(_cursorIndexOfMultiAddress);
                Peer _item = new Peer(_tmpPid, _tmpMultiAddress);
                int _tmp = _cursor.getInt(_cursorIndexOfIsRelay);
                boolean _tmpIsRelay = _tmp != 0;
                _item.setRelay(_tmpIsRelay);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfIsAutonat);
                boolean _tmpIsAutonat = _tmp_1 != 0;
                _item.setAutonat(_tmpIsAutonat);
                int _tmpRating = _cursor.getInt(_cursorIndexOfRating);
                _item.setRating(_tmpRating);
                String _tmp_2 = _cursor.getString(_cursorIndexOfAdditionals);
                Additionals _tmpAdditionals = Additionals.toAdditionals(_tmp_2);
                _item.setAdditionals(_tmpAdditionals);
                String _tmpHash = _cursor.getString(_cursorIndexOfHash);
                _item.setHash(_tmpHash);
                String _tmpBundle = _cursor.getString(_cursorIndexOfBundle);
                _item.setBundle(_tmpBundle);
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                _item.setTimestamp(_tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<Peer> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }
}

