package threads.core.mdl;

import android.app.Application;

import androidx.annotation.NonNull;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;

import java.util.List;

import threads.core.Singleton;
import threads.core.api.Server;
import threads.core.api.ThreadsDatabase;

public class ServersViewModel extends AndroidViewModel {
    private final LiveData<List<Server>> servers;

    public ServersViewModel(@NonNull Application application) {
        super(application);
        ThreadsDatabase threadsDatabase = Singleton.getInstance(
                application.getApplicationContext()).getThreadsDatabase();

        servers = threadsDatabase.serverDao().getLiveDataServers();
    }


    public LiveData<List<Server>> getServers() {
        return servers;
    }
}