/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.ColumnInfo;
import androidx.room.PrimaryKey;
import java.util.Comparator;
import java.util.Objects;
import threads.core.api.Entity;
import threads.ipfs.api.PID;

@androidx.room.Entity
public class Peer
extends Entity
implements Comparable<Peer> {
    public static Comparator<Peer> PeerComparator = (peer1, peer2) -> peer1.compareTo((Peer)peer2);
    @PrimaryKey
    @NonNull
    @ColumnInfo(name="pid")
    private final String pid;
    @NonNull
    @ColumnInfo(name="multiAddress")
    private String multiAddress;
    @ColumnInfo(name="isRelay")
    private boolean isRelay;
    @ColumnInfo(name="isAutonat")
    private boolean isAutonat;
    @ColumnInfo(name="rating")
    private int rating;

    Peer(@NonNull String pid, @NonNull String multiAddress) {
        this.pid = pid;
        this.multiAddress = multiAddress;
        this.isRelay = false;
        this.isAutonat = false;
        this.rating = 0;
    }

    public boolean isAutonat() {
        return this.isAutonat;
    }

    public void setAutonat(boolean autonat) {
        this.isAutonat = autonat;
    }

    public static Peer createPeer(@NonNull PID pid, @NonNull String multiAddress) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkNotNull((Object)multiAddress);
        return new Peer(pid.getPid(), multiAddress);
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Peer peer = (Peer)o;
        return this.pid.equals(peer.pid);
    }

    public String toString() {
        return "Peer{pid='" + this.pid + '\'' + ", multiAddress='" + this.multiAddress + '\'' + ", isRelay=" + this.isRelay + ", isAutonat=" + this.isAutonat + ", rating=" + this.rating + '}';
    }

    public int hashCode() {
        return Objects.hash(this.pid);
    }

    @NonNull
    public String getPid() {
        return this.pid;
    }

    public boolean isRelay() {
        return this.isRelay;
    }

    public void setRelay(boolean relay) {
        this.isRelay = relay;
    }

    @NonNull
    public String getMultiAddress() {
        return this.multiAddress;
    }

    public void setMultiAddress(@NonNull String multiAddress) {
        Preconditions.checkNotNull((Object)multiAddress);
        this.multiAddress = multiAddress;
    }

    @Override
    public int compareTo(@NonNull Peer peer) {
        return Double.compare(peer.rating, this.rating);
    }
}

