/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Peer;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.ipfs.api.PeerInfo;

public class GatewayService {
    public static final String TAG = GatewayService.class.getSimpleName();

    public static synchronized List<Peer> getPeers(@NonNull Context context, int unmRelays, int timeout, boolean protect, boolean cleanStoredPeers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((unmRelays >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 1000 ? 1 : 0) != 0);
        ArrayList<Peer> result = new ArrayList<Peer>();
        if (!Network.isConnected(context)) {
            return result;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        GatewayService.connectStoredPeers(context, unmRelays, timeout, cleanStoredPeers);
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            peers.sort(threads.ipfs.api.Peer::compareTo);
            for (threads.ipfs.api.Peer peer : peers) {
                if (result.size() == unmRelays) break;
                if (!peer.isRelay()) continue;
                if (ipfs.isConnected(peer.getPid())) {
                    if (protect) {
                        ipfs.protectPeer(peer.getPid(), TAG);
                    }
                    result.add(GatewayService.storePeer(context, peer));
                    continue;
                }
                if (!ipfs.swarmConnect(peer, timeout)) continue;
                if (protect) {
                    ipfs.protectPeer(peer.getPid(), TAG);
                }
                result.add(GatewayService.storePeer(context, peer));
            }
        }
        return result;
    }

    private static Peer storePeer(@NonNull Context context, @NonNull threads.ipfs.api.Peer peer) {
        int rating = 0;
        try {
            double latency = peer.getLatency();
            if (latency < 1000.0) {
                rating = (int)(1000.0 - latency);
            }
        }
        catch (Throwable latency) {
            // empty catch block
        }
        try {
            PeerInfo info;
            int timeout = Preferences.getMaxThreshold(context);
            IPFS ipfs = Singleton.getInstance(context).getIpfs();
            if (ipfs != null && (info = ipfs.id(peer, timeout)) != null) {
                Log.e((String)TAG, (String)("Info : " + info.toString()));
                String protocol = info.getProtocolVersion();
                String agent = info.getAgentVersion();
                rating = protocol != null && protocol.equals("ipfs/0.1.0") ? (rating += 100) : (rating -= 100);
                if (agent != null && agent.startsWith("go-ipfs/0.4.2")) {
                    rating += 100;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (rating < 0) {
            rating = 0;
        }
        return GatewayService.storePeer(context, peer.getPid(), peer.getMultiAddress(), peer.isRelay(), rating);
    }

    public static Peer storePeer(@NonNull Context context, @NonNull PID pid, @NonNull String multiAddress, boolean isRelay, int rating) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        Peer relay = threads.getPeerByPID(pid);
        if (relay != null) {
            relay.setMultiAddress(multiAddress);
            relay.setRelay(isRelay);
            relay.setRating(rating);
            threads.updatePeer(relay);
        } else {
            relay = threads.createPeer(pid, multiAddress);
            relay.setRelay(isRelay);
            relay.setRating(rating);
            threads.storePeer(relay);
        }
        return relay;
    }

    private static void connectStoredPeers(@NonNull Context context, int numConnections, int timeout, boolean cleanStoredPeers) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 1000 ? 1 : 0) != 0);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> relays = threads.getRelayPeers();
            relays.sort(Peer::compareTo);
            for (Peer relay : relays) {
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Relay : " + relay.toString()));
                if (ipfs.isConnected(PID.create((String)relay.getPid()))) {
                    counter.incrementAndGet();
                    continue;
                }
                String ma = relay.getMultiAddress() + "/" + IPFS.Style.ipfs.name() + "/" + relay.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    counter.incrementAndGet();
                    continue;
                }
                if (cleanStoredPeers) {
                    threads.removePeer(relay);
                    continue;
                }
                relay.setRating(0);
                threads.updatePeer(relay);
            }
        }
    }
}

