/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Addresses;
import threads.core.api.PeerInfo;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.ipfs.api.Peer;

@Deprecated
public class PeerInfoService {
    private static final int MAX_RELAYS = 3;
    private static final String TAG = PeerInfoService.class.getSimpleName();

    public static void publishPeer(@NonNull Context context, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        if (!Network.isConnected(context)) {
            return;
        }
        if (!Preferences.isSupportPeerDiscovery(context)) {
            return;
        }
        THREADS threads = Singleton.getInstance(context).getThreads();
        try {
            PID host = Preferences.getPID(context);
            if (host != null) {
                PeerInfo peer = threads.getPeerInfoByPID(host);
                if (peer != null) {
                    boolean isDirectPeerValid = PeerInfoService.isDirectPeerValid(context, peer);
                    int numRelays = PeerInfoService.updateRelays(context, peer);
                    if (numRelays < 3 || !isDirectPeerValid || !peer.hasHash()) {
                        Addresses addresses = peer.getAddresses();
                        List<Peer> relays = PeerInfoService.getRelayPeers(context, addresses.keySet());
                        Peer direct = null;
                        if (!isDirectPeerValid) {
                            direct = PeerInfoService.getDirectPeer(context);
                        }
                        PeerInfoService.updatePeerInfo(context, peer, aesKey, relays, direct);
                    }
                } else {
                    List<Peer> relays = PeerInfoService.getRelayPeers(context, new HashSet<String>());
                    Peer direct = PeerInfoService.getDirectPeer(context);
                    PeerInfoService.createPeerInfo(context, host, aesKey, relays, direct);
                }
            }
        }
        catch (Throwable e) {
            Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
        }
    }

    private static boolean isDirectPeerValid(@NonNull Context context, @NonNull PeerInfo peer) {
        String ma;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        int thresholdMax = Preferences.getMaxThreshold(context);
        AtomicBoolean peerValid = new AtomicBoolean(false);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null && !(ma = peer.getAdditional("peer")).isEmpty()) {
            String pid = peer.getAdditional("pid");
            if (!ipfs.isConnected(PID.create((String)pid))) {
                boolean connect = ipfs.swarmConnect(ma + "/" + IPFS.Style.ipfs.name() + "/" + pid, thresholdMax);
                if (connect) {
                    peerValid.set(true);
                } else {
                    Singleton.getInstance(context).getConsoleListener().debug("Direct peer not valid anymore : " + pid);
                }
            } else {
                peerValid.set(true);
            }
        }
        return peerValid.get();
    }

    private static int updateRelays(@NonNull Context context, @NonNull PeerInfo peer) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        int thresholdMax = Preferences.getMaxThreshold(context);
        AtomicInteger connected = new AtomicInteger(0);
        AtomicBoolean peerChanged = new AtomicBoolean(false);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Addresses addresses = peer.getAddresses();
        if (ipfs != null) {
            for (String relay : addresses.keySet()) {
                try {
                    String ma = (String)addresses.get(relay);
                    Preconditions.checkNotNull((Object)ma);
                    PID relayPID = PID.create((String)relay);
                    if (!ipfs.isConnected(relayPID)) {
                        boolean connect = ipfs.swarmConnect(ma + "/" + IPFS.Style.ipfs.name() + "/" + relay, thresholdMax);
                        if (connect) {
                            connected.incrementAndGet();
                            continue;
                        }
                        Singleton.getInstance(context).getConsoleListener().debug("Relay not valid anymore : " + relayPID);
                        peer.removeAddress(relay);
                        peerChanged.set(true);
                        continue;
                    }
                    connected.incrementAndGet();
                }
                catch (Throwable e) {
                    Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
                }
            }
        }
        if (peerChanged.get()) {
            Singleton.getInstance(context).getThreads().storePeerInfo(peer);
        }
        return connected.get();
    }

    private static void createPeerInfo(@NonNull Context context, @NonNull PID user, @NonNull String aesKey, @NonNull List<Peer> relays, @Nullable Peer direct) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        try {
            PeerInfo peer = threads.createPeerInfo(user);
            String alias = threads.getUserAlias(user);
            peer.addAdditional("alias", alias, false);
            if (direct != null) {
                peer.addAdditional("pid", direct.getPid().getPid(), false);
                peer.addAdditional("peer", direct.getMultiAddress(), false);
            }
            for (Peer relay : relays) {
                peer.addAddress(relay.getPid(), relay.getMultiAddress());
            }
            threads.storePeerInfo(peer);
            PeerInfoService.insertPeerInfo(context, peer, aesKey);
        }
        catch (Throwable e) {
            Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
        }
    }

    public static PeerInfo getPeerInfo(@NonNull Context context, @NonNull PID user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        if (Preferences.isSupportPeerDiscovery(context)) {
            return threads.getPeer(iota, user, aesKey);
        }
        return null;
    }

    private static void insertPeerInfo(@NonNull Context context, @NonNull PeerInfo peerInfo, @NonNull String aesKey) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        Preconditions.checkNotNull((Object)iota);
        threads.setHash(peerInfo, null);
        long start = System.currentTimeMillis();
        boolean success = threads.insertPeerInfo(iota, peerInfo, aesKey);
        long time = (System.currentTimeMillis() - start) / 1000L;
        if (success) {
            Singleton.getInstance(context).getConsoleListener().info("Success store peer : " + time + " [s]");
        } else {
            Singleton.getInstance(context).getConsoleListener().error("Failed store peer : " + time + " [s]");
        }
    }

    private static void updatePeerInfo(@NonNull Context context, @NonNull PeerInfo peerInfo, @NonNull String aesKey, @NonNull List<Peer> relays, @Nullable Peer direct) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        boolean update = false;
        try {
            if (direct != null && !direct.getMultiAddress().equals(peerInfo.getAdditional("peer"))) {
                update = true;
                peerInfo.addAdditional("pid", direct.getPid().getPid(), false);
                peerInfo.addAdditional("peer", direct.getMultiAddress(), false);
            }
            Addresses previous = peerInfo.getAddresses();
            for (Peer relay : relays) {
                peerInfo.addAddress(relay.getPid(), relay.getMultiAddress());
            }
            if (!previous.equals(peerInfo.getAddresses())) {
                update = true;
            }
            if (update) {
                threads.updatePeerInfo(peerInfo);
                PeerInfoService.insertPeerInfo(context, peerInfo, aesKey);
            }
        }
        catch (Throwable e) {
            Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
        }
    }

    @Nullable
    public static Peer getDirectPeer(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        int thresholdMax = Preferences.getMaxThreshold(context);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            for (Peer peer : peers) {
                if (peer.isRelay() || !ipfs.swarmConnect(peer, thresholdMax)) continue;
                Singleton.getInstance(context).getConsoleListener().debug("Direct Swarm PeerInfo : " + peer.toString());
                return peer;
            }
        }
        return null;
    }

    @NonNull
    private static List<Peer> getRelayPeers(@NonNull Context context, @NonNull Set<String> ignoreList) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(ignoreList);
        ArrayList<Peer> relays = new ArrayList<Peer>();
        int thresholdMax = Preferences.getMaxThreshold(context);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            for (Peer peer : peers) {
                if (!ignoreList.contains(peer.getPid().getPid()) && peer.isRelay() && ipfs.swarmConnect(peer, thresholdMax)) {
                    Singleton.getInstance(context).getConsoleListener().debug("Detect Swarm Relay PeerInfo : " + peer.toString());
                    relays.add(peer);
                }
                if (relays.size() < 3) continue;
                break;
            }
        }
        return relays;
    }
}

