/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import threads.core.IdentityService;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Members;
import threads.core.api.Note;
import threads.core.api.Thread;
import threads.core.api.User;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class ConnectService {
    private static final String TAG = ConnectService.class.getSimpleName();

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        boolean protectPeer = true;
        boolean protectRelay = true;
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return IdentityService.connectPeer(context, pid, aesKey, timeout, protectRelay, protectPeer);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static List<Future<Boolean>> publishNoteAsync(@NonNull Context context, @NonNull Note note, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Thread thread = threads.getThread(note);
        Preconditions.checkNotNull((Object)thread);
        boolean protectPeer = true;
        boolean protectRelay = true;
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    boolean result = IdentityService.connectPeer(context, pid, aesKey, protectRelay, protectPeer);
                    if (result) {
                        User user = threads.getUserByPID(pid);
                        Preconditions.checkNotNull((Object)user);
                        IPFS ipfs = Singleton.getInstance(context).getIpfs();
                        if (ipfs != null) {
                            return threads.publishNote(ipfs, user, note);
                        }
                        return false;
                    }
                    return result;
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        boolean protectPeer = true;
        boolean protectRelay = true;
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return IdentityService.connectPeer(context, pid, aesKey, protectRelay, protectPeer);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static boolean publishNote(@NonNull Context context, @NonNull Note note, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)aesKey);
        AtomicBoolean allSend = new AtomicBoolean(true);
        List<Future<Boolean>> futures = ConnectService.publishNoteAsync(context, note, aesKey);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                allSend.set(false);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                allSend.set(false);
            }
        }
        return allSend.get();
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)thread);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, int timeout, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey, timeout);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }
}

