/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import android.content.Context;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import java.util.HashMap;
import java.util.HashSet;
import threads.core.api.EventDao;
import threads.core.api.EventDao_Impl;
import threads.core.api.EventsDatabase;
import threads.core.api.MessageDao;
import threads.core.api.MessageDao_Impl;

public final class EventsDatabase_Impl
extends EventsDatabase {
    private volatile EventDao _eventDao;
    private volatile MessageDao _messageDao;

    protected SupportSQLiteOpenHelper createOpenHelper(DatabaseConfiguration configuration) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(configuration, new RoomOpenHelper.Delegate(1){

            public void createAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Event` (`identifier` TEXT NOT NULL, `content` TEXT NOT NULL, `date` INTEGER NOT NULL, PRIMARY KEY(`identifier`))");
                _db.execSQL("CREATE TABLE IF NOT EXISTS `Message` (`message` TEXT NOT NULL, `timestamp` INTEGER NOT NULL, `messageKind` INTEGER NOT NULL, `idx` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL)");
                _db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                _db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, 'e01adf63cd1757856fdde7a36a032812')");
            }

            public void dropAllTables(SupportSQLiteDatabase _db) {
                _db.execSQL("DROP TABLE IF EXISTS `Event`");
                _db.execSQL("DROP TABLE IF EXISTS `Message`");
            }

            protected void onCreate(SupportSQLiteDatabase _db) {
                if (EventsDatabase_Impl.this.mCallbacks != null) {
                    int _size = EventsDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)EventsDatabase_Impl.this.mCallbacks.get(_i)).onCreate(_db);
                    }
                }
            }

            public void onOpen(SupportSQLiteDatabase _db) {
                EventsDatabase_Impl.this.mDatabase = _db;
                EventsDatabase_Impl.this.internalInitInvalidationTracker(_db);
                if (EventsDatabase_Impl.this.mCallbacks != null) {
                    int _size = EventsDatabase_Impl.this.mCallbacks.size();
                    for (int _i = 0; _i < _size; ++_i) {
                        ((RoomDatabase.Callback)EventsDatabase_Impl.this.mCallbacks.get(_i)).onOpen(_db);
                    }
                }
            }

            public void onPreMigrate(SupportSQLiteDatabase _db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)_db);
            }

            public void onPostMigrate(SupportSQLiteDatabase _db) {
            }

            protected void validateMigration(SupportSQLiteDatabase _db) {
                HashMap<String, TableInfo.Column> _columnsEvent = new HashMap<String, TableInfo.Column>(3);
                _columnsEvent.put("identifier", new TableInfo.Column("identifier", "TEXT", true, 1));
                _columnsEvent.put("content", new TableInfo.Column("content", "TEXT", true, 0));
                _columnsEvent.put("date", new TableInfo.Column("date", "INTEGER", true, 0));
                HashSet _foreignKeysEvent = new HashSet(0);
                HashSet _indicesEvent = new HashSet(0);
                TableInfo _infoEvent = new TableInfo("Event", _columnsEvent, _foreignKeysEvent, _indicesEvent);
                TableInfo _existingEvent = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Event");
                if (!_infoEvent.equals((Object)_existingEvent)) {
                    throw new IllegalStateException("Migration didn't properly handle Event(threads.core.api.Event).\n Expected:\n" + _infoEvent + "\n Found:\n" + _existingEvent);
                }
                HashMap<String, TableInfo.Column> _columnsMessage = new HashMap<String, TableInfo.Column>(4);
                _columnsMessage.put("message", new TableInfo.Column("message", "TEXT", true, 0));
                _columnsMessage.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0));
                _columnsMessage.put("messageKind", new TableInfo.Column("messageKind", "INTEGER", true, 0));
                _columnsMessage.put("idx", new TableInfo.Column("idx", "INTEGER", true, 1));
                HashSet _foreignKeysMessage = new HashSet(0);
                HashSet _indicesMessage = new HashSet(0);
                TableInfo _infoMessage = new TableInfo("Message", _columnsMessage, _foreignKeysMessage, _indicesMessage);
                TableInfo _existingMessage = TableInfo.read((SupportSQLiteDatabase)_db, (String)"Message");
                if (!_infoMessage.equals((Object)_existingMessage)) {
                    throw new IllegalStateException("Migration didn't properly handle Message(threads.core.api.Message).\n Expected:\n" + _infoMessage + "\n Found:\n" + _existingMessage);
                }
            }
        }, "e01adf63cd1757856fdde7a36a032812", "6bdf32706de58ae0e5837c9ea936ab81");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)configuration.context).name(configuration.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = configuration.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"Event", "Message"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `Event`");
            _db.execSQL("DELETE FROM `Message`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventDao eventDao() {
        if (this._eventDao != null) {
            return this._eventDao;
        }
        EventsDatabase_Impl eventsDatabase_Impl = this;
        synchronized (eventsDatabase_Impl) {
            if (this._eventDao == null) {
                this._eventDao = new EventDao_Impl(this);
            }
            return this._eventDao;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageDao messageDao() {
        if (this._messageDao != null) {
            return this._messageDao;
        }
        EventsDatabase_Impl eventsDatabase_Impl = this;
        synchronized (eventsDatabase_Impl) {
            if (this._messageDao == null) {
                this._messageDao = new MessageDao_Impl(this);
            }
            return this._messageDao;
        }
    }
}

