package threads.core.api;

import androidx.annotation.NonNull;

import java.util.HashMap;

import static androidx.core.util.Preconditions.checkNotNull;

public class ServerEncoder {

    @NonNull
    public static Content convert(@NonNull Server server) {
        Content content = new Content();

        content.put(Content.PORT, "" + server.getPort());
        content.put(Content.PROTOCOL, server.getProtocol());
        content.put(Content.HOST, server.getHost());
        content.put(Content.ALIAS, server.getAlias());


        HashMap<String, String> additions = server.getExternalAdditions();
        checkNotNull(additions);
        content.put(Content.ADDS, Additionals.toString(additions));

        return content;
    }
}
