/*
 * Decompiled with CFR 0.152.
 */
package threads.core.api;

import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.room.TypeConverter;

public enum UserStatus {
    OFFLINE(0),
    BLOCKED(1),
    ONLINE(2),
    DIALING(3);

    @NonNull
    private final Integer code;

    private UserStatus(Integer code) {
        Preconditions.checkNotNull((Object)code);
        this.code = code;
    }

    @TypeConverter
    public static UserStatus toUserStatus(Integer status) {
        Preconditions.checkNotNull((Object)status);
        if (status.equals(OFFLINE.getCode())) {
            return OFFLINE;
        }
        if (status.equals(ONLINE.getCode())) {
            return ONLINE;
        }
        if (status.equals(BLOCKED.getCode())) {
            return BLOCKED;
        }
        if (status.equals(DIALING.getCode())) {
            return DIALING;
        }
        throw new IllegalArgumentException("Could not recognize status");
    }

    @TypeConverter
    public static Integer toInteger(UserStatus status) {
        Preconditions.checkNotNull((Object)((Object)status));
        return status.getCode();
    }

    @NonNull
    private Integer getCode() {
        return this.code;
    }
}

