/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import threads.core.Network;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Peer;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.ipfs.api.PeerInfo;

public class GatewayService {
    private static final String TAG = GatewayService.class.getSimpleName();
    public static Comparator<threads.ipfs.api.Peer> PeerComparator = new Comparator<threads.ipfs.api.Peer>(){

        @Override
        public int compare(threads.ipfs.api.Peer peer1, threads.ipfs.api.Peer peer2) {
            return peer1.compareTo(peer2);
        }
    };

    @Nullable
    public static Peer getPeer(@NonNull Context context, @NonNull List<PID> ignore, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull(ignore);
        Preconditions.checkArgument((numConnections > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 1000 ? 1 : 0) != 0);
        if (!Network.isConnected(context)) {
            return null;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        GatewayService.evaluateStoredRelays(context, numConnections, timeout);
        if (ipfs != null) {
            List peers = ipfs.swarmPeers();
            peers.sort(PeerComparator);
            for (threads.ipfs.api.Peer peer : peers) {
                if (ignore.contains(peer.getPid()) || !peer.isRelay()) continue;
                if (ipfs.isConnected(peer.getPid())) {
                    PeerInfo info = ipfs.id(peer, timeout);
                    if (info != null) {
                        Log.e((String)TAG, (String)(info.getAgentVersion() + "  " + info.getProtocolVersion()));
                    }
                    return GatewayService.storePeer(context, peer.getPid(), peer.getMultiAddress(), true, true);
                }
                if (!ipfs.swarmConnect(peer, timeout)) continue;
                return GatewayService.storePeer(context, peer.getPid(), peer.getMultiAddress(), true, true);
            }
            if (!peers.isEmpty()) {
                threads.ipfs.api.Peer peer = (threads.ipfs.api.Peer)peers.get(0);
                return GatewayService.storePeer(context, peer.getPid(), peer.getMultiAddress(), peer.isRelay(), ipfs.isConnected(peer.getPid()));
            }
        }
        return null;
    }

    public static Peer storePeer(@NonNull Context context, @NonNull PID pid, @NonNull String multiAddress, boolean isRelay, boolean connect) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        Peer relay = threads.getPeerByPID(pid);
        if (relay != null) {
            relay.setMultiAddress(multiAddress);
            relay.setRelay(isRelay);
            relay.setConnected(connect);
            threads.updatePeer(relay);
        } else {
            relay = threads.createPeer(pid, multiAddress);
            relay.setRelay(isRelay);
            relay.setConnected(connect);
            threads.storePeer(relay);
        }
        return relay;
    }

    private static void evaluateStoredRelays(@NonNull Context context, int numConnections, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((numConnections > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((timeout > 1000 ? 1 : 0) != 0);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        THREADS threads = Singleton.getInstance(context).getThreads();
        AtomicInteger counter = new AtomicInteger(0);
        if (ipfs != null) {
            List<Peer> relays = threads.getRelayPeers();
            for (Peer relay : relays) {
                if (counter.get() == numConnections) break;
                Log.e((String)TAG, (String)("Stored Relay : " + relay.toString()));
                String ma = relay.getMultiAddress() + "/" + IPFS.Style.ipfs.name() + "/" + relay.getPid();
                if (ipfs.swarmConnect(ma, timeout)) {
                    relay.setConnected(true);
                    threads.updatePeer(relay);
                    counter.incrementAndGet();
                    continue;
                }
                threads.removePeer(relay);
            }
        }
    }
}

