/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import threads.core.Network;
import threads.core.PeerService;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.Addresses;
import threads.core.api.Members;
import threads.core.api.Note;
import threads.core.api.PeerInfo;
import threads.core.api.Thread;
import threads.core.api.User;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;

public class ConnectService {
    private static final String TAG = ConnectService.class.getSimpleName();

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return ConnectService.connectUser(context, pid, aesKey, timeout);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static List<Future<Boolean>> publishNoteAsync(@NonNull Context context, @NonNull Note note, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Thread thread = threads.getThread(note);
        Preconditions.checkNotNull((Object)thread);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    boolean result = ConnectService.connectUser(context, pid, aesKey);
                    if (result) {
                        User user = threads.getUserByPID(pid);
                        Preconditions.checkNotNull((Object)user);
                        IPFS ipfs = Singleton.getInstance(context).getIpfs();
                        if (ipfs != null) {
                            return threads.publishNote(ipfs, user, note);
                        }
                        return false;
                    }
                    return result;
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static List<Future<Boolean>> connectMembersAsync(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        ArrayList<Future<Boolean>> futures = new ArrayList<Future<Boolean>>();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        Members members = thread.getMembers();
        for (PID pid : members) {
            Future<Boolean> future = executorService.submit(() -> {
                try {
                    return ConnectService.connectUser(context, pid, aesKey);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                    return false;
                }
            });
            futures.add(future);
        }
        return futures;
    }

    public static boolean publishNote(@NonNull Context context, @NonNull Note note, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)note);
        Preconditions.checkNotNull((Object)aesKey);
        AtomicBoolean allSend = new AtomicBoolean(true);
        List<Future<Boolean>> futures = ConnectService.publishNoteAsync(context, note, aesKey);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                allSend.set(false);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                allSend.set(false);
            }
        }
        return allSend.get();
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)thread);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    public static boolean connectMembers(@NonNull Context context, @NonNull Thread thread, @NonNull String aesKey, int timeout, boolean shortcut) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)thread);
        Preconditions.checkNotNull((Object)aesKey);
        boolean result = true;
        List<Future<Boolean>> futures = ConnectService.connectMembersAsync(context, thread, aesKey, timeout);
        for (Future<Boolean> future : futures) {
            try {
                if (future.get().booleanValue()) continue;
                result = false;
                if (!shortcut) continue;
                return result;
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                result = false;
            }
        }
        return result;
    }

    private static void connectDirect(@NonNull Context context, @NonNull PeerInfo peer) {
        String ma;
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        int thresholdMax = Preferences.getMaxThreshold(context);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null && !(ma = peer.getAdditional("peer")).isEmpty()) {
            String pid = peer.getAdditional("pid");
            ipfs.swarmConnect(ma + "/" + IPFS.Style.ipfs.name() + "/" + pid, thresholdMax);
        }
    }

    private static boolean connectRelays(@NonNull Context context, @NonNull PeerInfo peer, long start, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        int minThreshold = Preferences.getMinThreshold(context);
        Threshold threshold = new Threshold(minThreshold);
        boolean dialRelay = Preferences.isDialRelay(context);
        AtomicBoolean connected = new AtomicBoolean(false);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        Addresses addresses = peer.getAddresses();
        if (ipfs != null) {
            for (String relay : addresses.keySet()) {
                try {
                    boolean connect;
                    String ma = (String)addresses.get(relay);
                    Preconditions.checkNotNull((Object)ma);
                    boolean relayConnected = ipfs.swarmConnect(ma + "/" + IPFS.Style.ipfs.name() + "/" + relay, ConnectService.time(threshold, start, timeout));
                    if (!dialRelay || !relayConnected || !(connect = ipfs.swarmConnect(ma = ma.concat("/" + IPFS.Style.ipfs.name() + "/" + relay + "/p2p-circuit/" + IPFS.Style.ipfs.name() + "/" + peer.getPID().getPid()), ConnectService.time(threshold, start, timeout)))) continue;
                    connected.set(true);
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return connected.get();
    }

    private static int time(Threshold threshold, long start, int timeout) {
        if (timeout > 0) {
            int passedTime = (int)(System.currentTimeMillis() - start);
            if (passedTime < timeout) {
                if (threshold.maxThreshold > 0) {
                    return threshold.maxThreshold;
                }
                return timeout - passedTime;
            }
            return threshold.minThreshold;
        }
        return timeout;
    }

    public static boolean connectUser(@NonNull Context context, @NonNull PID user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        int timeout = Preferences.getConnectionTimeout(context);
        return ConnectService.connectUser(context, user, aesKey, timeout);
    }

    public static boolean connectUser(@NonNull Context context, @NonNull PID user, @NonNull String aesKey, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        if (!Network.isConnected(context)) {
            return false;
        }
        int minThreshold = Preferences.getMinThreshold(context);
        Threshold threshold = new Threshold(minThreshold);
        long start = System.currentTimeMillis();
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            PeerInfo peer = PeerService.getPeerInfo(context, user, aesKey);
            if (peer != null) {
                if (ConnectService.connectRelays(context, peer, start, ConnectService.time(threshold, start, timeout))) {
                    return true;
                }
                ConnectService.connectDirect(context, peer);
            }
            return ipfs.swarmConnect(user, ConnectService.time(threshold, start, timeout));
        }
        return false;
    }

    public static boolean swarm_connect(@NonNull Context context, @NonNull PID pid, int timeout) {
        Preconditions.checkNotNull((Object)pid);
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            return ipfs.swarmConnect(pid, timeout);
        }
        return false;
    }

    private static class Threshold {
        private final int minThreshold;
        private final int maxThreshold;

        Threshold(int minThreshold) {
            this.minThreshold = minThreshold;
            this.maxThreshold = 0;
        }

        Threshold(int minThreshold, int maxThreshold) {
            this.minThreshold = minThreshold;
            this.maxThreshold = maxThreshold;
        }

        public int getMinThreshold() {
            return this.minThreshold;
        }

        public int getMaxThreshold() {
            return this.maxThreshold;
        }
    }
}

