/*
 * Decompiled with CFR 0.152.
 */
package threads.core;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import threads.core.Network;
import threads.core.Preferences;
import threads.core.Singleton;
import threads.core.THREADS;
import threads.core.api.MultiAddresses;
import threads.core.api.Peer;
import threads.iota.IOTA;
import threads.ipfs.IPFS;
import threads.ipfs.api.PID;
import threads.ipfs.api.PeerInfo;

public class IdentityService {
    private static final String TAG = IdentityService.class.getSimpleName();
    private static final String PROTOCOL = "/ipfs/";
    private static final String SUPPORT_PEER_DISCOVERY_KEY = "supportPeerDiscoveryKey";

    public static boolean isSupportPeerDiscovery(@NonNull Context context) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(TAG, 0);
        return sharedPref.getBoolean(SUPPORT_PEER_DISCOVERY_KEY, true);
    }

    public static void setSupportPeerDiscovery(@NonNull Context context, boolean enable) {
        Preconditions.checkNotNull((Object)context);
        SharedPreferences sharedPref = context.getSharedPreferences(TAG, 0);
        SharedPreferences.Editor editor = sharedPref.edit();
        editor.putBoolean(SUPPORT_PEER_DISCOVERY_KEY, enable);
        editor.apply();
    }

    public static void identity(@NonNull Context context, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        ExecutorService executor = Executors.newSingleThreadExecutor();
        executor.submit(() -> {
            try {
                if (Network.isConnected(context)) {
                    IdentityService.publishIdentity(context, aesKey);
                }
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("" + e.getLocalizedMessage()), (Throwable)e);
            }
        });
    }

    public static boolean publishIdentity(@NonNull Context context, @NonNull String aesKey) {
        block9: {
            Preconditions.checkNotNull((Object)context);
            Preconditions.checkNotNull((Object)aesKey);
            if (!Network.isConnected(context)) {
                return false;
            }
            if (!IdentityService.isSupportPeerDiscovery(context)) {
                return false;
            }
            IPFS ipfs = Singleton.getInstance(context).getIpfs();
            THREADS threads = Singleton.getInstance(context).getThreads();
            if (ipfs != null) {
                try {
                    PID host = Preferences.getPID(context);
                    if (host == null) break block9;
                    PeerInfo info = ipfs.id();
                    Preconditions.checkNotNull((Object)info);
                    List<String> addresses = IdentityService.getMultiAddresses(info);
                    Peer peer = threads.getPeerByPID(host);
                    if (peer != null) {
                        boolean update;
                        boolean bl = update = !peer.hasHash();
                        if (!update) {
                            MultiAddresses multiAddresses = peer.getMultiAddresses();
                            for (String address : addresses) {
                                if (multiAddresses.contains(address)) continue;
                                update = true;
                                break;
                            }
                        }
                        if (update) {
                            return IdentityService.updatePeer(context, peer, aesKey, addresses);
                        }
                        break block9;
                    }
                    return IdentityService.createPeer(context, host, aesKey, addresses);
                }
                catch (Throwable e) {
                    Singleton.getInstance(context).getConsoleListener().debug("" + e.getLocalizedMessage());
                }
            }
        }
        return false;
    }

    private static List<String> getMultiAddresses(@NonNull PeerInfo info) {
        Preconditions.checkNotNull((Object)info);
        ArrayList<String> addresses = new ArrayList<String>();
        for (String address : info.getMultiAddresses()) {
            String ending;
            if (address.startsWith("/ip6/::1/") || address.startsWith("/ip4/127.0.0.1/") || !address.endsWith(ending = PROTOCOL + info.getPID().getPid())) continue;
            String smallAddress = address.substring(0, address.length() - ending.length());
            addresses.add(smallAddress);
        }
        return addresses;
    }

    private static boolean createPeer(@NonNull Context context, @NonNull PID user, @NonNull String aesKey, @NonNull List<String> addresses) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        Peer peer = threads.createPeer(user);
        String alias = threads.getUserAlias(user);
        peer.addAdditional("alias", alias, false);
        for (String address : addresses) {
            peer.addMultiAddresses(address);
        }
        threads.storePeer(peer);
        return IdentityService.insertPeer(context, peer, aesKey);
    }

    public static Peer getPeer(@NonNull Context context, @NonNull PID user, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)user);
        Preconditions.checkNotNull((Object)aesKey);
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        if (IdentityService.isSupportPeerDiscovery(context)) {
            return threads.getPeer(iota, user, aesKey);
        }
        return null;
    }

    private static boolean insertPeer(@NonNull Context context, @NonNull Peer peer, @NonNull String aesKey) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        IOTA iota = Singleton.getInstance(context).getIota();
        Preconditions.checkNotNull((Object)iota);
        threads.setHash(peer, null);
        long start = System.currentTimeMillis();
        boolean success = threads.insertPeer(iota, peer, aesKey);
        long time = (System.currentTimeMillis() - start) / 1000L;
        if (success) {
            Singleton.getInstance(context).getConsoleListener().info("Success store peer : " + time + " [s]");
        } else {
            Singleton.getInstance(context).getConsoleListener().error("Failed store peer : " + time + " [s]");
        }
        return success;
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PID peer, @NonNull String aesKey) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)peer);
        int timeout = Preferences.getConnectionTimeout(context);
        return IdentityService.connectPeer(context, peer, aesKey, timeout);
    }

    public static boolean connectPeer(@NonNull Context context, @NonNull PID user, @NonNull String aesKey, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)aesKey);
        Preconditions.checkNotNull((Object)user);
        if (!Network.isConnected(context)) {
            return false;
        }
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        if (ipfs != null) {
            Peer peer = IdentityService.getPeer(context, user, aesKey);
            if (peer != null && IdentityService.connectPeer(context, peer, timeout)) {
                return true;
            }
            return ipfs.swarmConnect(user, timeout);
        }
        return false;
    }

    private static boolean connectPeer(@NonNull Context context, @NonNull Peer peer, int timeout) {
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)peer);
        Singleton.ConsoleListener consoleListener = Singleton.getInstance(context).getConsoleListener();
        IPFS ipfs = Singleton.getInstance(context).getIpfs();
        MultiAddresses addresses = peer.getMultiAddresses();
        if (ipfs != null) {
            for (String address : addresses) {
                try {
                    String ma = address.concat(PROTOCOL + peer.getPID().getPid());
                    consoleListener.debug("Try connect : " + ma);
                    boolean connect = ipfs.swarmConnect(ma, timeout);
                    if (!connect) continue;
                    consoleListener.info("Success connect : " + ma);
                    return true;
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }

    private static boolean updatePeer(@NonNull Context context, @NonNull Peer peer, @NonNull String aesKey, @NonNull List<String> addresses) {
        THREADS threads = Singleton.getInstance(context).getThreads();
        peer.removeMultiAddresses();
        for (String address : addresses) {
            peer.addMultiAddresses(address);
        }
        threads.updatePeer(peer);
        return IdentityService.insertPeer(context, peer, aesKey);
    }
}

