package threads.core.api;

import androidx.annotation.NonNull;

import com.google.gson.Gson;

import java.util.HashMap;

import threads.ipfs.api.Encryption;

import static androidx.core.util.Preconditions.checkNotNull;

public class PeerEncoder {
    @NonNull
    public static String convert(@NonNull Peer peer, @NonNull String aesKey) {
        checkNotNull(peer);
        checkNotNull(aesKey);

        Content content = new Content();
        Gson gson = new Gson();
        try {
            String addresses = Addresses.toString(peer.getAddresses());

            if (addresses != null) {
                content.put(Content.PEERS, Encryption.encrypt(addresses, aesKey));
            }

            String multiAddresses = MultiAddresses.toString(peer.getMultiAddresses());


            if (multiAddresses != null) {
                content.put(Content.MADS, Encryption.encrypt(multiAddresses, aesKey));
            }


            HashMap<String, String> additions = peer.getExternalAdditions();
            checkNotNull(additions);
            content.put(Content.ADDS, Encryption.encrypt(Additionals.toString(additions), aesKey));


            return gson.toJson(content);


        } catch (Throwable e) {
            throw new RuntimeException(e);
        }


    }
}
