package threads.core.api;

import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.gson.Gson;

import threads.iota.Entity;
import threads.ipfs.api.Encryption;
import threads.ipfs.api.PID;

import static androidx.core.util.Preconditions.checkNotNull;

public class PeerDecoder {
    private static final String TAG = PeerDecoder.class.getSimpleName();

    @Nullable
    public static Peer convert(@NonNull PID owner, @NonNull Entity entity, @NonNull String aesKey) {
        checkNotNull(owner);
        checkNotNull(entity);
        checkNotNull(aesKey);
        Gson gson = new Gson();

        try {

            Content content = gson.fromJson(entity.getContent(), Content.class);
            Peer peer = convert(owner, content, aesKey);
            if (peer != null) {
                peer.setHash(entity.getHash());
                peer.setBundle(entity.getBundle());
                peer.setTimestamp(entity.getTimestamp());
            }
            return peer;

        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
        return null;
    }

    @Nullable
    public static Peer convert(@NonNull PID owner, @NonNull Content content, @NonNull String aesKey) {
        checkNotNull(owner);
        checkNotNull(content);
        checkNotNull(aesKey);
        try {
            Peer peer = Peer.createPeer(owner);


            String peers = content.get(Content.PEERS);
            if (peers != null) {
                Addresses addresses = Addresses.toAddresses(Encryption.decrypt(peers, aesKey));
                checkNotNull(addresses);
                peer.setAddresses(addresses);
            }


            String mads = content.get(Content.MADS);
            if (mads != null) {
                MultiAddresses multiAddresses = MultiAddresses.toMultiAddresses(
                        Encryption.decrypt(mads, aesKey));
                checkNotNull(multiAddresses);
                peer.setMultiAddresses(multiAddresses);
            }


            String additions = content.get(Content.ADDS);
            checkNotNull(additions);

            if (!additions.isEmpty()) {
                peer.setExternalAdditions(Additionals.toHashMap(
                        Encryption.decrypt(additions, aesKey)));
            }

            return peer;

        } catch (Throwable e) {
            Log.e(TAG, "" + e.getLocalizedMessage(), e);
        }
        return null;
    }
}
