/*
 * Decompiled with CFR 0.152.
 */
package threads.core.mdl;

import android.app.Application;
import androidx.annotation.NonNull;
import androidx.core.util.Preconditions;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import threads.core.Singleton;
import threads.core.api.ThreadsDatabase;
import threads.core.api.User;
import threads.ipfs.api.PID;

public class UserViewModel
extends AndroidViewModel {
    private final ThreadsDatabase threadsDatabase;

    public UserViewModel(@NonNull Application application) {
        super(application);
        this.threadsDatabase = Singleton.getInstance(application.getApplicationContext()).getThreadsDatabase();
    }

    public LiveData<User> getUser(@NonNull PID pid) {
        Preconditions.checkNotNull((Object)pid);
        Preconditions.checkArgument((!pid.getPid().isEmpty() ? 1 : 0) != 0);
        return this.threadsDatabase.userDao().getLiveDataUser(pid.getPid());
    }
}

